/***************************************************************************
    file	         : kb_componentbase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COMPONENTBASE_H
#define	__KB_COMPONENTBASE_H


#include	"kb_libloader.h"
#include	"kb_objbase.h"
#include	"kb_componentviewer.h"

class	KBComponentBase : public KBObjBase
{
	Q_OBJECT

	KBComponent		*m_docRoot	;
	KBComponentViewer	*m_viewer	;

private slots :

	void	widgetClosing () ;

public	:

	KBComponentBase	(QObject * = 0, cchar * = 0) ;
	virtual		~KBComponentBase ()	;

	virtual	bool		build
		(		KBLocation &,
				bool,
				KBError &
		) ;

	virtual	KB::ShowRC	show
		(		KB::ShowAs		,
				const QDict<QString>	&,
				QWidget			*,
				KBError			&,
				const KBValue		& = KBValue(),
				QDict<QString>		* = 0
		) ;

	virtual	QString		def	() ;
}	;


#ifndef _WIN32
KBPARTFACTORY(KBComponentFactory,"componentviewer")
#else

class KBComponentFactory : public KBPartFactory
{
public:
	
	inline	KBComponentFactory() : KBPartFactory ()
	{
	}
	virtual	QObject	*create
		(	QObject			* = 0,
			const char		* = 0,
			const char		* = 0, 
			const QStringList	& = QStringList()
		)	;
	virtual	const char *ident() ;
}	;
#endif

#endif	// __KB_COMPONENTBASE_H
