/***************************************************************************
    file	         : kb_tablewidget.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_serverinfo.h"

#ifndef 	_WIN32
#include	"kb_tablewidget.moc"
#else
#include 	"kb_tablewidget.h"
#endif

#include	"tk_icons.h"



/*  KBTableWidget							*/
/*  KBTableWidget: Constructor for table copier widget			*/
/*  parent	 : QWidget *	: Parent widget				*/
/*  part	 : QObject *	: Parent copier part			*/
/*  srce	 : bool		: Table is source			*/
/*  location	 : KBLocation &	: Database location			*/
/*  (returns)	 : KBTableWidget:					*/

KBTableWidget::KBTableWidget
	(	QWidget		*parent,
		QObject		*part,
		bool		srce,
		KBLocation	&location
	)
	:
	QWidget		(parent),
	KBCopyTable	(srce, location),
	m_part		(part),
	m_srce		(srce),
	m_location	(location),
	m_cbServer	(this),
	m_cbTable	(this),
	m_lbFields	(this),
	m_lbSelect	(this),
	m_bAdd		(this),
	m_bAddAll	(this),
	m_bRemove	(this),
	m_bUp		(this),
	m_bDown		(this),
#if	__KB_EMBEDDED
	m_wBottom	(this),
#else
	m_gbBottom	(2, Qt::Horizontal, srce ? TR("Where/Order") : TR("Operation"), this),
	m_wBottom	(&m_gbBottom),
#endif
	m_fldChooser
	(	location,
		m_cbServer, m_cbTable, m_lbFields, m_lbSelect,
		m_bAdd,	    m_bAddAll, m_bRemove,  m_bUp,      m_bDown,
		true,
		true
	)
{
	int	 mlw	= 0 ;

	QVBoxLayout	*layMain   = new QVBoxLayout (this     ) ;
	QHBoxLayout	*layTable  = new QHBoxLayout (layMain  ) ;

	layTable ->addWidget (&m_cbServer) ;
	layTable ->addWidget (&m_cbTable ) ;

	QHBoxLayout	*laySelect = new QHBoxLayout (layMain  ) ;
	laySelect->addWidget (&m_lbFields) ;
	QVBoxLayout	*layButton = new QVBoxLayout (laySelect) ;
	laySelect->addWidget (&m_lbSelect) ;

	layButton->addWidget (&m_bAdd    ) ;
	layButton->addWidget (&m_bAddAll ) ;

	if (!m_srce)
	{
		m_bAddAuto = new QPushButton (this)	;
		layButton ->addWidget(m_bAddAuto)	;
		m_bAddAuto->setText  (TR("Add Auto"))	;
		connect (m_bAddAuto, SIGNAL(clicked()), SLOT(slotAddAuto())) ;
	}

	layButton->addWidget (&m_bRemove ) ;
	layButton->addWidget (&m_bUp     ) ;
	layButton->addWidget (&m_bDown   ) ;
	layButton->addStretch()	 ;

	QLabel		*lExpr		;
	QLabel		*lWhere		;
	QLabel		*lOrder		;
	QGridLayout	*layBottom	;

	if (m_srce)
	{
		QHBoxLayout *layExpr = new QHBoxLayout	(layMain) ;

		lExpr   = new QLabel	  (this) ;
		m_eExpr	= new QLineEdit	  (this) ;
		m_bExpr	= new QPushButton (this) ;

		layExpr->addWidget (lExpr  ) ;
		layExpr->addWidget (m_eExpr) ;
		layExpr->addWidget (m_bExpr) ;

		lExpr  ->setText   (TR("Expression")) ;
		m_bExpr->setPixmap (getSmallIcon("insert")) ;

		connect	(m_bExpr, SIGNAL(clicked()), SLOT(clickExpr())) ; 

		mlw	= lExpr->sizeHint().width() ;
	}

#if	__KB_EMBEDDED
	layMain  ->addWidget (&m_wBottom ) ;
#else
	layMain  ->addWidget (&m_gbBottom) ;
#endif

	if (srce)
	{
		lWhere	  = new QLabel      (&m_wBottom ) ;
		m_eWhere  = new QLineEdit   (&m_wBottom ) ;
		lOrder	  = new QLabel      (&m_wBottom ) ;
		m_eOrder  = new QLineEdit   (&m_wBottom ) ;
		layBottom = new QGridLayout (&m_wBottom ) ;

		layBottom->addWidget (lWhere,   0, 0) ;
		layBottom->addWidget (m_eWhere, 0, 1) ;
		layBottom->addWidget (lOrder,   1, 0) ;
		layBottom->addWidget (m_eOrder, 1, 1) ;

		lWhere->setText (TR("Where")) ;
		lOrder->setText (TR("Order By")) ;
		connect
		(	m_eWhere,
			SIGNAL(textChanged(const QString &)),
			part,
			SLOT(setChanged())
		)	;

		if (lWhere->minimumSizeHint().width() > mlw)
			mlw = lWhere->sizeHint().width() ;
		if (lOrder->minimumSizeHint().width() > mlw)
			mlw = lOrder->sizeHint().width() ;
	}
	else
	{
		m_cbOption   = new QComboBox   (&m_wBottom ) ;
		m_cbOptField = new QComboBox   (&m_wBottom ) ;
		layBottom    = new QGridLayout (&m_wBottom ) ;

		layBottom->addWidget (m_cbOption,   0, 0) ;
		layBottom->addWidget (m_cbOptField, 0, 1) ;

		m_cbOption->insertItem (TR("Append"       )) ;
		m_cbOption->insertItem (TR("Replace"	  )) ;
		m_cbOption->insertItem (TR("Update"       )) ;
		m_cbOption->insertItem (TR("Update/insert")) ;
		m_cbOption->insertItem (TR("Insert new"   )) ;
		m_cbOption->insertItem (TR("Compare"      )) ;

		connect	(m_cbOption,   SIGNAL(activated(int)), this, SLOT(optSelected(int))) ;
		connect	(m_cbOptField, SIGNAL(activated(int)), part, SLOT(setChanged (   ))) ;

		m_cbOptField->setEnabled (false) ;
	}


#if	__KB_EMBEDDED
	m_lbFields.setMinimumWidth ( 75) ;
	m_lbSelect.setMinimumWidth ( 75) ;

	if (m_srce && (mlw > 0))
	{	lExpr ->setFixedWidth (mlw) ;
		lWhere->setFixedWidth (mlw) ;
		lOrder->setFixedWidth (mlw) ;
	}
#else
	m_lbFields.setMinimumWidth (120) ;
	m_lbSelect.setMinimumWidth (120) ;
#endif

	_KBDialog::setupLayout  (layMain,   -1, -1) ;
	_KBDialog::setupLayout  (layBottom, -1, -1) ;

	connect	(this,	        SIGNAL(changed	  ()),	   part, SLOT(   setChanged ())) ;
	connect	(&m_fldChooser, SIGNAL(fieldsChanged()), 	   part, SLOT(   setChanged ())) ;
	connect	(&m_fldChooser, SIGNAL(selectChanged(bool)), part, SLOT(   setChanged ())) ;
	connect	(&m_fldChooser, SIGNAL(selectChanged(bool)), this, SLOT(selectChanged (bool))) ;

//	setMinimumHeight (layMain->minimumSize().height() + 50) ;
}

/*  KBTableWidget							*/
/*  selectChanged: Handle change in selected fields			*/
/*  delta	 : bool		: True if contents changed		*/
/*  (returns)	 : void		:					*/

void	KBTableWidget::selectChanged
	(	bool	delta
	)
{
	if (delta && !m_srce)
	{
		QString	curVal	= m_cbOptField->currentText() ;
		int	idx1	= -1 ;

		m_cbOptField->clear () ;
		for (uint idx2 = 0 ; idx2 < m_lbSelect.count() ; idx2 += 1)
		{	QString	field	= m_lbSelect.text(idx2) ;
			m_cbOptField->insertItem (field) ;
			if (field == curVal) idx1 = m_cbOptField->count() - 1 ;
		}

		if (idx1 >= 0) m_cbOptField->setCurrentItem (idx1) ;
	}
}

/*  KBTableWidget							*/
/*  slotAddAuto	: Add an auto field					*/
/*  (returns)	: void		:					*/

void	KBTableWidget::slotAddAuto ()
{
	int cur = m_lbSelect.currentItem()  ;
	m_lbSelect.insertItem     ("<Auto>", cur + 1) ;
	m_lbSelect.setCurrentItem (cur + 1) ;
	m_bRemove.setEnabled (true) ;
}

/*  KBTableWidget							*/
/*  clickExpr	: User clicks add-expression button			*/
/*  (returns)	: void		:					*/

void	KBTableWidget::clickExpr ()
{
	QString	expr	;

	if (m_srce && !(expr = m_eExpr->text()).isEmpty())
	{
		int	sCur	= m_lbSelect.currentItem () + 1 ;
		m_lbSelect.insertItem     (expr, sCur) ;
		m_lbSelect.setCurrentItem (sCur) ;
		emit changed () ;
	}
}


/*  KBTableWidget							*/
/*  optSelected	: User selects a destination option			*/
/*  idx		: int		: Option index				*/
/*  (returns)	: void		:					*/

void	KBTableWidget::optSelected
	(	int	idx
	)
{
	if (!m_srce)
	{	m_cbOptField->setEnabled (idx >= 2) ;
		emit	changed	 () ;
	}
}


/*  KBTableWidget							*/
/*  saveall	: Save all settings					*/
/*  (returns)	: void		:					*/

void	KBTableWidget::saveall ()
{
	reset	() ;
	setServer (m_cbServer.currentText()) ;
	setTable  (m_cbTable .currentText()) ;

	for (uint idx = 0 ; idx < m_lbSelect.count() ; idx += 1)
		addField (m_lbSelect.text (idx)) ;

	if (m_srce)
	{	setWhere  (m_eWhere->text()) ;
		setOrder  (m_eOrder->text()) ;
	}
	else	setOption (m_cbOption->currentItem(), m_cbOptField->currentText()) ;
}

/*  KBTableWidget							*/
/*  error	: KBError &	 : Error return				*/
/*  (returns)	: bool		 : Success				*/

bool	KBTableWidget::valid
	(	KBError		&error
	)
{
	saveall () ;
	return	KBCopyTable::valid (error) ;
}

/*  KBTableWidget								*/
/*  set		: Set copier from definition				*/
/*  copy	: QDomElement & : Definition parent			*/
/*  error	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBTableWidget::set
	(	QDomElement	&copy,
		KBError		&error
	)
{
	if (!KBCopyTable::set (copy, error)) return false ;

	QStringList &fl = getFields () ;

	m_lbSelect.clear () ;
	m_lbFields.clear () ;

	if (!m_fldChooser.setServer (getServer ())) return true ;
	if (!m_fldChooser.setObject (getTable  ())) return true ;

	for (uint idx1 = 0 ; idx1 < fl.count() ; idx1 += 1)
		m_lbSelect.insertItem (*fl.at(idx1)) ;
	
	if (m_srce)
	{
		m_eWhere->setText (getWhere ()) ;
		m_eOrder->setText (getOrder ()) ;
		return	true ;
	}


	m_cbOption->setCurrentItem (getOption()) ;

	for (uint idx2 = 0 ; idx2 < fl.count() ; idx2 += 1)
		m_cbOptField->insertItem (*fl.at(idx2)) ;

	for (int idx3 = 0 ; idx3 < m_cbOptField->count() ; idx3 += 1)
		if (m_cbOptField->text(idx3) == getOptField())
		{	m_cbOptField->setCurrentItem (idx3) ;
			break	;
		}

	m_cbOptField->setEnabled (m_cbOption->currentItem() >= 2) ;
	return	true	;

}

/*  KBTableWidget							*/
/*  def		: Get table copy definition				*/
/*  copy	: QDomElement &	: Element to which to attach		*/
/*  (returns)	: void		:					*/

void	KBTableWidget::def
	(	QDomElement	&copy
	)
{
	saveall () ;
	return	KBCopyTable::def (copy) ;
}
