/***************************************************************************
    file	         : kb_editorbase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<errno.h>
#include	<time.h>

#include	<qwidget.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attrdict.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_form.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"
#include	"kb_viewer.h"
#include	"kb_build.h"

#include	"kb_editor.h"

#include	"kb_objbase.h"

#ifndef 	_WIN32
#include	"kb_editorbase.moc"
#else
#include	"kb_editorbase.h"
#endif

/*  KBEditorBase:							*/
/*  KBEditorBase: Constructor for base object for script editing	*/
/*  parent	: QObject *	: Parent object				*/
/*  (returns)	: KBEditor	:					*/

KBEditorBase::KBEditorBase
	(	QObject		*parent
	)
	:
	KBObjBase (parent)
{
	m_editor = 0 ;
}

/*  KBEditorBase :							*/
/*  ~KBEditorBase: Destructor for base object for script editing	*/
/*  (returns)	 :		:					*/

KBEditorBase::~KBEditorBase ()
{
}

/*  KBEditorBase:							*/
/*  build	: Build an instance of an object			*/
/*  location	: KBLocation &	  : Object location			*/
/*  create	: bool		  : Creating a new object		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: bool		  :					*/

bool	KBEditorBase::build
	(	KBLocation	&location,
		bool		create,
		KBError		&
	)
{
	setLocation  (location)	;
	m_create   = create	;
	return	true	;
}

/*  KBEditorBase:							*/
/*  show	: Show editor						*/
/*  showAs	: KB::ShowAs	  : Initial display mode		*/
/*  pDict	: QDict<QString>& : Parameter dictionary		*/
/*  embed	: QWidget *	  : Widget into which to embed display	*/
/*  pError	: KBError &	  : Error return			*/
/*  key		: const KBValue & : Parent key				*/
/*  rDict	: QDict<QString>* : Results dictionary			*/
/*  (returns)	: KBasePart *	  : New child part			*/

KB::ShowRC
	KBEditorBase::show
	(	KB::ShowAs		,
		const QDict<QString>	&pDict,
		QWidget			*embed,
		KBError			&,
		const KBValue		&,
		QDict<QString>		*
	)
{
	QString	errPat	;
	QString	errText	;
	uint	lno	= 0 ;
	QString	*p	;

	if ((p = pDict.find ("errPat" )) != 0) errPat  = *p ;
	if ((p = pDict.find ("errText")) != 0) errText = *p ;
	if ((p = pDict.find ("lno"    )) != 0) lno     = p->toUInt () ;

	if (m_editor == 0)
	{
		m_editor = new KBEditor  (this, embed) ;
		setPart	(m_editor, false) ;

		m_editor->startup (errPat, errText, lno, m_create) ;
		return	KB::ShowRCOK ;
	}

	m_editor->widget()->setFocus() ;
	m_editor->reloadScript (errPat, errText, lno) ;
	return	KB::ShowRCOK ;
}

QString	KBEditorBase::def ()
{
	return	m_editor->def() ;
}

void	KBEditorBase::widgetClosing ()
{
}

/*  -----------------------------------------------------------------  */


KBFACTORYIMPL
(	KBEditorFactory,
	editor,
	"Rekall script editor",
	"Plugin",
	"0",
	"7",
	"0"
)

QObject	*KBEditorFactory::create
	(	QObject		  *parent,
		cchar		  *,
		cchar		  *className,
		const QStringList &
	)
{
	if ((className != 0) && (strcmp (className, "browser") == 0))
		return	0 ;

	return	new	KBEditorBase (parent) ;
}

cchar	*KBEditorFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
