/***************************************************************************
    file	         : kb_macrolist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qcursor.h>
#include	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"
#include	"kb_listitem.h"
#include	"kb_viewer.h"
#include	"kb_callback.h"
#include	"kb_macro.h"
#include	"kb_appptr.h"

#ifndef 	_WIN32
#include	"kb_macrolist.moc"
#else
#include 	"kb_macrolist.h"
#endif



/*  KBMacoList								*/
/*  KBMacoList	: Constructor for macro list widget			*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  dbInfo	: KBDBInfo *	  : Database information object		*/
/*  (returns)	: KBMacoList	  :					*/

KBMacroList::KBMacroList
	(	QWidget		*parent,
		KBDBInfo	*dbInfo
	)
	:
	KBFileList
	(	parent,
		dbInfo,
		"Create new macro",
		"macro",
		"macro",
		"Macro name"
	)
{
}

/*  KBMacroList								*/
/*  ~KBMacroList	: Destructor for macro list widget			*/
/*  (returns)	:		:					*/

KBMacroList::~KBMacroList ()
{
}

/*  KBMacroList								*/
/*  showServerMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBMacroList::showServerMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertSeparator () ;
	pop.insertItem (TR("&Reload macro list"),  this, SLOT(reloadServer())) ;
	pop.insertItem (TR("&Copy to server ..."), this, SLOT(copyToServer())) ;
	pop.exec       (QCursor::pos()) ;
}

/*  KBMacroList								*/
/*  showObjectMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBMacroList::showObjectMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertItem (TR("&Execute macro"), this, SLOT(showAsData  ())) ;
	pop.insertItem (TR("&Edit macro"),    this, SLOT(showAsDesign())) ;
	pop.insertItem (TR("&Rename macro"),  this, SLOT(renameMacro ())) ;
	pop.insertItem (TR("De&lete macro"),  this, SLOT(deleteMacro ())) ;
	pop.insertItem (TR("&Save to file"),  this, SLOT(saveToFile  ())) ;
	pop.exec       (QCursor::pos()) ;
}

/*  KBMacroList								*/
/*  renamemacro	: Rename a macro					*/
/*  (returns)	: void		:					*/

void	KBMacroList::renameMacro ()
{
	rename	(m_curItem) ;
}

/*  KBMacroList								*/
/*  deleteComponment							*/
/*		: Delete a macro					*/
/*  (returns)	: void		:					*/

void	KBMacroList::deleteMacro ()
{
	delobj	(m_curItem) ;
}

void	KBMacroList::showObjectAs
	(	KBListItem	*item,
		KB::ShowAs	showAs
	)
{
	if (showAs == KB::ShowAsData)
	{
		KBLocation	location ;
		KBError		error 	 ;

		if (!itemToLocation (m_curItem, location))
			return ;

		bool	ok	= KBMacroExec::execute
				  (	location,
					error
				  )	;

		if (!ok) error.DISPLAY();
		return	;
	}

	KBFileList::showObjectAs (item, showAs) ;
}
