/***************************************************************************
    file	         : kb_tablealias.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qimage.h>
#include	<qsizegrip.h>
#include	<qobjectlist.h>
#include	<qcursor.h>
#include	<qpainter.h>

#if		__KB_EMBEDDED
#include	<qpe/qpeapplication.h>
#endif


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_node.h"
#include	"kb_query.h"
#include	"kb_table.h"

#include	"kb_querydlg.h"

#ifndef		_WIN32
#include	"kb_tablealias.moc"
#else
#include	"kb_tablealias.h"
#endif

#include	"tk_icons.h"



/*  KBTableListBoxItem							*/
/*  paint	: Handle paint operation on field entry			*/
/*  painter	: QPainter *	: Paint object				*/
/*  (returns)	: void		:					*/

void	KBTableListBoxItem::paint
	(	QPainter	*painter
	)
{
	static	QImage	*kImg	;

	/* First time round load the key marker image ...		*/
	if (kImg == 0)
		kImg = new QImage  (getSmallIcon("key").convertToImage()) ;

	/* ... and draw it if this is the preferred key fieldd.		*/
	if (m_pKey)
		painter->drawImage (2, 0, *kImg, 0, 0, kImg->width(), kImg->height(), 0) ;

	/* Move the painter origin to miss the key marker, and then	*/
	/* display the text as normal.					*/
	painter->translate  (20, 0) ;
	QListBoxText::paint (painter) ;
}

/*  ------------------------------------------------------------------  */

/*  KBTableAlias							*/
/*  KBTableAlias: Constructor for table alias/join object		*/
/*  qryDlg	: KBQueryDlg *	: Owning query dialog			*/
/*  table	: KBTable *	: Real table node			*/
/*  (returns)	: KBTableAlias	:					*/

KBTableAlias::KBTableAlias
	(	KBQueryDlg	*qryDlg,
		KBTable		*table
	)
	:
	QWidget		(qryDlg->getQrySpace(), 0, WStyle_Customize|WStyle_NormalBorder|WStyle_Title),
	m_fieldList	(this),
	m_qryDlg		(qryDlg),
	m_table		(table)
{
	m_layout	= new QVBoxLayout (this) ;

#if	__KB_EMBEDDED
	QPalette pal = QApplication::palette () ;
	pal.setColor (QColorGroup::Foreground, 	white   ) ;
	pal.setColor (QColorGroup::Background,	darkBlue) ;

	m_legend	= new QLabel (this)	;
	m_legend->setPalette   (pal)		;
	m_layout->addWidget    (m_legend)	;

	m_legend->installEventFilter (this)	;
#endif
	m_layout->addWidget    (&m_fieldList) 	;


#if	__KB_EMBEDDED
	QPEApplication::setStylusOperation
	(	m_legend,
		QPEApplication::RightOnHold
	)	;
#endif
	setLegend () ;

	m_fieldList.setSelectionMode   (QListBox::NoSelection) ;

	QRect	tg	= table->geometry ()  	;
	if (tg.width()  == 0) tg.setWidth (140) ;
	if (tg.height() == 0) tg.setHeight(180) ;
	setGeometry	 (tg) ;


	/* Populate the list box with column names. The key column, if	*/
	/* any, is marked with a key icon. Note that the column is	*/
	/* picked up from the table object definition. This works	*/
	/* since when a table is added, the uniqueness will have been	*/
	/* set at that point; thereafter the user can change it.	*/
	QStringList		uNames	;
	QString			uExpr	;
	KBTableSpec		tabSpec	(m_table->getTable ()) ;
	m_table->getUnique	(uNames, uExpr);

	if (!qryDlg->getDBLink().listFields (tabSpec))
	{
		qryDlg->getDBLink().lastError().DISPLAY() ;
		return	;
	}

	for (uint idx = 0 ; idx < tabSpec.m_fldList.count() ; idx += 1)
	{
		KBFieldSpec	*fSpec	= tabSpec.m_fldList.at(idx) ;
		bool		isPKey	= fSpec->m_name == uNames[0] ;

		new KBTableListBoxItem (&m_fieldList, fSpec->m_name, isPKey) ;

		if (isPKey) m_keyField = fSpec->m_name ;
	}

	/* Connect the listbox scrolling signal to the main dialog. It	*/
	/* will use this to redraw the links. Also pick up mouse	*/
	/* mouse presses, which lead to context menus.			*/
	connect	(&m_fieldList, SIGNAL(contentsMoving (int, int)),
		 m_qryDlg,     SLOT  (repaintLinks   ())) ;
	connect (&m_fieldList, SIGNAL(mouseButtonPressed (int, QListBoxItem *, const QPoint &)),
		 this,	       SLOT  (fieldButtonPressed (int, QListBoxItem *, const QPoint &))) ;

#if	__KB_EMBEDDED
	setFixedWidth (110) ;
#endif
	show	() ;
}

#if	__KB_EMBEDDED

/*  KBTableAlias							*/
/*  eventFilter	: Event filter for embedded objects			*/
/*  o		: QObject *	: Object to which applies		*/
/*  e		: Event *	: The event				*/
/*  (returns)	: bool		: Event consumed			*/

bool	KBTableAlias::eventFilter
	(	QObject		*,
		QEvent		*e
	)
{
	if (e->type() == QEvent::MouseButtonPress)
		if (((QMouseEvent *)e)->button() == Qt::RightButton)
		{	m_qryDlg->showContextMenu (this) ;
			return	true	;
		}

	return	false	;
}
#endif

void	KBTableAlias::fieldButtonPressed
	(	int		button,
		QListBoxItem	*item,
		const QPoint	&
	)
{
	if (button == Qt::RightButton)
	{
		m_qryDlg->showContextMenu (this) ;
		return	;
	}

	if (button == Qt::LeftButton)
	{
		if (item != 0)
			m_qryDlg->startLinking (this, item->text()) ;
		return	;
	}
}

/*  KBTableAlias							*/
/*  setLegend	: Set legend						*/
/*  (returns)	: void		  :					*/

void	KBTableAlias::setLegend ()
{
	QString	caption	;

	if (m_table->getAlias().isEmpty())
		caption	= m_table->getTable() ;
	else	caption	= QString("%1 as %2")
				 .arg(m_table->getTable())
				 .arg(m_table->getAlias()) ;

#if	__KB_EMBEDDED
	m_legend->setText (" " + caption) ;
#else	
	setCaption 	  (caption) ;
#endif
}

/*  KBTableAlias							*/
/*  setAlias	: Set table alias					*/
/*  alias	: const QString & : Alias				*/
/*  (returns)	: void		  :					*/

void	KBTableAlias::setAlias
	(	const QString	&alias
	)
{
	m_table->setAlias (alias) ;
	setLegend	  ()	  ;
}

/*  KBTableAlias							*/
/*  setPrimary	: Set table primary field				*/
/*  primary	: const QString & : Primary				*/
/*  utype	: UniqueType	  : Uniqueness type			*/
/*  (returns)	: void		  :					*/

void	KBTableAlias::setPrimary
	(	const QString		&primary,
		KBTable::UniqueType	utype
	)
{
	m_keyField = primary ;

	for (uint idx = 0 ; idx < m_fieldList.count() ; idx += 1)
	{
		KBTableListBoxItem *tlbi = (KBTableListBoxItem *)m_fieldList.item(idx) ;
		tlbi->setPKey (tlbi->text() == primary) ;
	}

	m_table->setPrimary (primary, utype) ;
	m_fieldList.triggerUpdate (true) ;
}

/*  KBTableAlias							*/
/*  reparent	: Handle reparenting					*/
/*  parent	: QWidget *	 : New parent				*/
/*  flags	: WFlags	 : New flags				*/
/*  p		: const QPoint & : New position				*/
/*  showIt	: bool		 : Show after reparenting		*/
/*  (returns)	: void		 :					*/

void	KBTableAlias::reparent
	(	QWidget		*parent,
		WFlags		flags,
		const QPoint	&p,
		bool		showIt
	)
{
	QWidget::reparent (parent, flags, p, showIt) ;
	parent->installEventFilter (m_qryDlg) ;
}

/*  KBTableAlias							*/
/*  getPosition	: Get position for specified field			*/
/*  field	: const QString & : Field name				*/
/*  onright	: bool		  : True to return RHS position		*/
/*  ispk	: bool &	  : Field is preferred key		*/
/*  (returns)	: QPoint	  : Position				*/

QPoint	KBTableAlias::getPosition
	(	const QString	&field,
		bool		onright,
		bool		&ispk
	)
{
	int	slot	= -1 ;
	QPoint	pp	;
	QRect	fr	= m_fieldList.geometry () ;

	/* Scan through the list box to locate the specified field. It	*/
	/* really should be there ...					*/
	for (uint idx = 0 ; idx < m_fieldList.count() ; idx += 1)
		if (m_fieldList.text(idx) == field)
		{	KBTableListBoxItem *tlbi = (KBTableListBoxItem *)m_fieldList.item(idx) ;
			slot	= idx ;
			ispk	= tlbi->isPkey() ;
			break	;
		}

	/* ... but if not then return the origin.			*/
	if	(slot < 0)
	{
		pp	= QPoint (0, 0) ;
		ispk	= false		;
	}
	/* If found but not visible then return either the top or the	*/
	/* bottom of the list box, depending on which way it is hidden.	*/
	else if (!m_fieldList.itemVisible(slot))
	{
		pp	= QPoint
			  (	0,
				slot < m_fieldList.topItem() ? 0 : fr.height()
			  )	;
	}
	/* If visible then return the position mid-way down the area	*/
	/* that it occupies.						*/
	else
	{
		QRect	ir = m_fieldList.itemRect (m_fieldList.item(slot)) ;
		int	y  = ir.top() + ir.height()/2 ;

		if (y > m_fieldList.height()) y = m_fieldList.height() ;
		if (y < 0		    ) y = 0 ;

		pp	= QPoint (0, y) ;
	}

	/* The result is the position in the workspace coordinates, so	*/
	/* offset for the widget than the workspace wraps with.		*/
#if	__KB_EMBEDDED
	QRect	lbr	= QRect
			  (	x(),
				y() + m_legend->height(),
				m_fieldList.width (),
				m_fieldList.height()
			  )	;
#else
	QRect	lbr	= QRect
			  (	parentWidget()->x() + x(),
			        parentWidget()->y() + y(),
				m_fieldList.width (),
				m_fieldList.height()
			  )	;
#endif
	if (onright)
		pp	= QPoint (lbr.right(), pp.y() + lbr.top()) ;
	else	pp	= QPoint (lbr.left (), pp.y() + lbr.top()) ;

	return	pp	;			
}

/*  KBTableAlias							*/
/*  hit		: See if position hits a list box item			*/
/*  p		: QPoint	: Position in global coordinates	*/
/*  field	: QString &	: Field name if hit			*/
/*  (returns)	: bool		: Hit					*/

bool	KBTableAlias::hit
	(	QPoint		p,
		QString		&field
	)
{
	QListBoxItem	*item	;

	if ((item = m_fieldList.itemAt (m_fieldList.mapFromGlobal(p))) != 0)
	{	field	= item->text () ;
		return	true	;
	}

	return	false	;
}

QRect	KBTableAlias::geometry ()
{
#if	__KB_EMBEDDED
	return	QWidget::geometry() ;
#else
	return	parentWidget()->geometry() ;
#endif
}


