/***************************************************************************
    file	         : kb_querydlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QUERYDLG_H
#define	_KB_QUERYDLG_H


#include	<qsplitter.h>

#include	<qlistbox.h>
#include	<qlistview.h>
#include	<qlineedit.h>
#include	<qcombobox.h>
#include	<qlabel.h>
#include	<qtextview.h>
#include	<qpushbutton.h>

#include	<qlayout.h>
#include	<qpopupmenu.h>
#include	<qtimer.h>


#include	"kb_editlistview.h"
#include	"kb_tablealias.h"
#include	"kb_resizewidget.h"
#include	"kb_location.h"
#include	"kb_dblink.h"


#if		__KB_EMBEDDED
#include	"tktabwidget.h"
#include	"tktabbar.h"
#include	"kb_qryspace_emb.h"
#include	"kb_querydlg_emb.h"
#else
#include	"kb_qryspace_std.h"
#include	"kb_querydlg_std.h"
#endif



class	KBQueryDlg	;
class	KBQueryExprs	;


class	KBQueryExprs : public KBEditListView
{
public	:

	KBQueryExprs	(QWidget *)	;

	virtual	void	fillCombo   (QComboBox &, uint, const QString &) ; 
}	;


/*  KBQueryDlg								*/
/*  ----------								*/
/*  Design dialog for KBase queries. Actually, it isn't a dialog at all	*/
/*  in the Qt sense, but it looks like one to the user.			*/

class	KBQueryDlg : public KBQueryDlgBase
{
	Q_OBJECT

	QWidget			*parent		;

	KBLocation		&location	;
	KBQuery			*qryRoot	;
	KBaseGUI		*designGUI	;

	QWidget			tblPicker	;

#if	! __KB_EMBEDDED
	QHBoxLayout		hLayMain	;
#endif
	QVBoxLayout		vLayPick	;

	QComboBox		serverList	;

	QListBox		allTables	;

	KBResizeFrame		qryDisplay	;
	KBQueryspace		qrySpace	;

	KBQueryExprs		expressions	;
	QTextView		SQLView		;

	QTimer			exprTimer	;
	QPopupMenu		*popup		;

	int			serverIndex	;
	int			tableIndex	;
	KBDBLink		dbLink		;
	KBTableAlias		*curTable	;

	QList<KBTableAlias>	tabList		;
	KBTableAlias		*trackTable	;
	QString			trackField	;

	void		serverConnect	() ;
	void		buildDisplay	() ;

	QString		getUniqueAlias	(const QString   &) ;
	KBTable::UniqueType
			getPrimary	(const QString   &, QString &) ;

	void		setChanged	() ;
	void		loadSQL		() ;

	bool		hasAncestor	(KBTable *, KBTable *) ;
	bool		nameIsFree	(const QString   &, bool) ;
	bool		updateExprs	(bool) ;

	KBTableAlias	*findTable	(QWidget         *) ;
	KBTableAlias	*findTable	(QPoint, QString &) ;

#if	0
	bool		hasCommas	(const QString &) ;
#endif

protected :

	virtual	void	resizeEvent	  (QResizeEvent  *) ;
	virtual	void	mouseReleaseEvent (QMouseEvent   *) ;
	virtual bool	eventFilter	  (QObject *, QEvent *) ;


private	slots :

	void		displayResize	(KBResizeFrame *, QSize) ;
	void		serverSelected	(int  ) ;
	void		tableSelected	(QWidget       *) ;

	void		clickAddTable	() ;
	void		clickDropTable	() ;

	void		setAlias	() ;
	void		setKey		() ;

	void		exprChanged	(uint, uint) ;
	void		exprChanged	() ;
	bool		updateExprs	() ;

public	slots	:

	void		repaintLinks	() 	;

public	:

	KBQueryDlg (QWidget *, KBLocation &, KBQuery *, KBaseGUI *) ;
       ~KBQueryDlg () ;

	QSize		sizeHint	()	;
	void		repaintLinks	(QPaintEvent *) ;
	void		linkProperties	(QPoint);

	void		showContextMenu	(KBTableAlias *) ;
	void		startLinking	(KBTableAlias *, QString) ;

	inline	QWidget	*getQrySpace	()
	{
		return	qrySpace.spaceWidget ()	;
	}
	inline	KBDBLink&getDBLink	()
	{
		return	dbLink		;
	}

	bool		saveDocument	()	;

	QValueList<int>	exprSizes	()	;
	void		setExprSizes	(QValueList<int>) ;
}	;

#define	TABITER(list,name)	\
	for (KBTableAlias *name = (KBTableAlias *)list .firstChild () ;	\
							    name != 0 ;	\
			  name  = (KBTableAlias *)name->nextSibling() )


#endif	//_KB_QUERYDLG_H
