/***************************************************************************
    file	         : kb_queryviewer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_QUERYVIEWER_H
#define  _KB_QUERYVIEWER_H


#include	<qguardedptr.h>
#include	"kb_viewer.h"

/*  KBQueryViewer							*/
/*  -------------							*/
/*  This class is used to directly view queries, either in design or	*/
/*  data mode. 								*/

class	KBQueryViewer : public KBViewer
{
	Q_OBJECT

	KBQuery			*m_qryRoot	;
	KBForm			*m_qryForm	;
	KBaseGUI		*m_dataGUI	;

#if	! __KB_RUNTIME
	QGuardedPtr<KBQueryDlg>	m_qryDialog	;
	KBaseGUI		*m_designGUI	;
#endif

	KB::ShowAs		m_showing	;


	KB::ShowRC	showDesign	(KBError &)	;
	KB::ShowRC	showData    	(KBError &)	;
	void		saveLayout	()	;
	bool		connectedOK	()	;

public	:

		 KBQueryViewer (KBObjBase *, QWidget *) ;
	virtual	~KBQueryViewer () ;

	virtual	KBQueryViewer	*isQueryViewer	() { return this ; }
	virtual	cchar		*getChanged	(bool) ;

	KB::ShowRC		startup		(KBQuery *, KB::ShowAs, KBError &) ;
	virtual	bool		queryClose	() ;

public	slots	:

	virtual	void	showAs  	   	(KB::ShowAs)	;

	void		saveDocument    	()		;
	void		saveDocumentAs  	()		;

	void		dbaseAction		(int)		;
	void		reload	        	()		;
}	;


extern	KBForm	*KBOpenQuery	 (KBLocation &, KBQuery *, KBError &) ;

#endif // _KB_QUERYVIEWER_H
