/***************************************************************************
    file	         : kb_qrydesign.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	 _KB_QRYDESIGN_H
#define	 _KB_QRYDESIGN_H


#include "kb_qrybase.h"
#include "kb_tableinfo.h"


/*  KBQryDesign								*/
/*  ------------							*/
/*  This class is used for the table-design query. In encapsulates	*/
/*  information specific to this type of query, but via the base class	*/
/*  KBQryBase provides a common interface for the KBBlock class.	*/

class	KBQryDesign : public KBQryBase
{
	KBAttrStr		server		;
	KBAttrStr		table		;
	KBAttrBool		create		;

	bool			ddExists	;

	KBItem			*fieldName	;
	KBItem			*fieldType	;
	KBItem			*fieldPrimary	;
	KBItem			*fieldDescr	;
	KBItem			*fieldNullOK	;
	KBItem			*fieldLen	;
	KBItem			*fieldPrec	;
	KBItem			*fieldIndex	;
	KBItem			*fieldUnique	;

	QString			tabName		;
	QString			svrName		;
	QList<KBItem>		tblOuter	;
	QList<KBItem>		tblInner	;

	QString			oldName		;
	QString			tmpName		;

	QString			selectQuery	;
	QString			insertQuery	;
	QString			updateQuery	;
	QString			deleteQuery	;

	KBTableSpec		oldSpec		;
	KBTableSpec		newSpec		;
	bool			isNew		;
	int			pkIdx		;
	uint			curQRow		;

	KBTableInfo		*tabInfo	;
	QList<KBTableColumn>	designInfo	;

	bool			copyOldData	()		;
	void			finish		(bool)		;


public	:

	KBQryDesign	(KBNode *, const QDict<QString> &, bool * = 0) ;
virtual~KBQryDesign	() ;

	virtual	KBQryDesign	*isQryDesign() { return this ; }

	virtual	bool		addItem      	(uint, KBItem  *) ;
	virtual	void		remItem      	(uint, KBItem  *) ;
	virtual	bool		loadItems    	(uint, uint)      ;
	virtual	bool		clearItems    	(uint, uint)      ;
	virtual	void		resetData 	(uint, uint) ;

	virtual	void		prepare		()	;
	virtual	bool		getSelect	(uint, KBSelect &);

	virtual	bool		select       	(uint, KBValue *,
						       const QString &,
						       const QString &,
						       const QString &,
						       bool = false, uint = 0) ;
	virtual	bool		startUpdate    	(uint, uint, KBQryBase::Locking) ;
	virtual	bool		endUpdate	(uint, bool) ;
	virtual KBQryBase::Locking
				lockingState	(uint)	     ;

	virtual	bool		saveRow      	(uint, uint) ;
	virtual	bool		deleteRow    	(uint, uint) ;
	virtual	bool		insertRow    	(uint, uint) ;
	virtual	bool		syncRow	     	(uint, uint, KBValue *, const QString &, KBBlock *, KB::Action &, KBValue &) ;
	virtual	bool		syncAll	     	(uint, 	     KBValue *, const QString &, KBBlock *) ;

	virtual	bool		newRowEmpty  	(uint, uint)	;
	virtual	bool		rowIsDirty   	(uint, uint, bool) ;
	virtual	KB::RState	getRowState  	(uint, uint)	;
	virtual	KBValue		getField     	(uint, uint, uint, bool =    false) ;
	virtual	void		setField     	(uint, uint, uint, const KBValue &) ;
	virtual uint		getNumRows   	(uint)		;
	virtual	uint		setCurrentRow	(uint, uint)	;
	virtual	uint		getPermission	(uint)		;
	virtual	void		sortByColumn	(uint, uint, bool, KBItem *) ;

	virtual	bool		getFieldList 	(uint, QList<KBFieldSpec> &, int &) ;

	virtual	bool		propertyDlg  	() ;

	bool			setLocation	(const QString  &, const QString &) ;

	inline	const QString	&getServerName	() { return svrName ; }
	inline	const QString	&getTableName	() { return tabName ; }

	virtual	uint	getWidth
		(	uint		,
			uint
		)
	{
		return	0 ;
	}

	virtual	void	setRowMarked
		(	uint		,
			uint		,
			KB::MarkOp
		)
	{
	}
	virtual	bool	getRowMarked
		(	uint		,
			uint
		)
	{
		return	false	;
	}
	virtual	bool	deleteAllMarked
		(	uint		,
			uint		&nrows
		)
	{
		nrows	= 0	;
		return	true	;
	}
	virtual	QString	getComment
		(	uint
		)
	{
		return	QString::null	;
	}
	virtual	QString	getSQLText
		(	uint	,
			bool
		)
	{
		return	QString::null	;
	}
	virtual	QString	getSQLReason
		(	uint
		)
	{
		return	QString::null	;
	}
}	;

#endif	// _KB_QRYDESIGN_H
