/***************************************************************************
    file	         : kb_tablefilterdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_tableinfo.h"

#include	"tk_messagebox.h"


#ifndef		_WIN32
#include	"kb_tablefilterdlg.moc"
#else
#include	"kb_tablefilterdlg.h"
#endif


class	KBFilterLVItem : public QListViewItem
{
	bool			m_asc	;
	KBTableSelect::Operator	m_oper	;

public	:

	KBFilterLVItem
	(	QListView	*,
		QListViewItem	*,
		KBFilterLVItem	*
	)	;

	KBFilterLVItem
	(	QListView	*,
		QListViewItem	*,
		const QString	&,
		const QString	& = QString::null,
		const QString	& = QString::null
	)	;

	inline	void	setAsc
		(	bool	asc
		)
	{
		m_asc	= asc	;
	}
	inline	bool	asc	()
	{
		return	m_asc	;
	}

	inline	void	setOper
		(	KBTableSelect::Operator	oper
		)
	{
		m_oper	= oper	;
	}
	inline	KBTableSelect::Operator	oper ()
	{
		return	m_oper	;
	}
}	;


KBFilterLVItem::KBFilterLVItem
	(	QListView	*parent,
		QListViewItem	*after,
		KBFilterLVItem	*extant
	)
	:
	QListViewItem	(parent, after)
{
	setText (0, extant->text(0)) ;
	setText (1, extant->text(1)) ;
	setText (2, extant->text(2)) ;
	setAsc  (extant->asc ()) ;
	setOper (extant->oper()) ;
}

KBFilterLVItem::KBFilterLVItem
	(	QListView	*parent,
		QListViewItem	*after,
		const QString	&text1,
		const QString	&text2,
		const QString	&text3
	)
	:
	QListViewItem	(parent, after, text1, text2, text3)
{
	m_asc	= true	;
}


/*  ------------------------------------------------------------------  */

/*  KBTableFilterDlg							*/
/*  KBTableFilterDlg							*/
/*		: Constructor for base filter dialog			*/
/*  tableSpec	: KBTableSpec &	   : Table specification		*/
/*  tableInfo	: KBTableInfo *	   : Table information			*/
/*  caption	: const QString &  : Dialog box caption			*/
/*  (returns)	: KBTableFilterDlg :					*/

KBTableFilterDlg::KBTableFilterDlg
	(	KBTableSpec	&tableSpec,
		KBTableInfo	*tableInfo,
		const QString	&caption
	)
	:
	_KBDialog	(caption, true),
	m_label		(this),
	m_name		(this),
	m_filterSet	(this),
	m_bMoveUp	(this),
	m_bMoveDown	(this),
	m_bAdd		(this),
	m_bRemove	(this),
	m_bOK		(this),
	m_bCancel	(this),
	m_tableSpec	(tableSpec),
	m_tableInfo	(tableInfo)
{
	QVBoxLayout	*layMain = new QVBoxLayout (this) ;

	QHBoxLayout	*layName = new QHBoxLayout (layMain) ;
	layName->addWidget (&m_label  ) ;
	layName->addWidget (&m_name   ) ;

	layMain->addWidget (&m_filterSet) ;

	m_layCols = new QHBoxLayout (layMain) ;

	QGridLayout	*layButt = new QGridLayout (layMain) ;
	layButt->addWidget (&m_bMoveUp,  0, 0) ;
	layButt->addWidget (&m_bMoveDown,1, 0) ;
	layButt->addWidget (&m_bAdd,     0, 1) ;
	layButt->addWidget (&m_bRemove,  1, 1) ;
	layButt->addWidget (&m_bOK,      0, 2) ;
	layButt->addWidget (&m_bCancel,  1, 2) ;

	m_label    .setText (TR("Name"	     )) ;
	m_bMoveUp  .setText (TR("Move Up"    )) ;
	m_bMoveDown.setText (TR("Move Down"  )) ;
	m_bAdd	   .setText (TR("Add"        )) ;
	m_bRemove  .setText (TR("Remove"     )) ;
	m_bOK	   .setText (TR("OK"	     )) ;
	m_bCancel  .setText (TR("Cancel"     )) ;

	m_filterSet.setSorting	      (-1    ) ;
	m_filterSet.setSelectionMode  (QListView::Single) ;
	m_filterSet.setMultiSelection (false ) ;

	connect
	(	&m_filterSet,
		SIGNAL(clicked	     (QListViewItem *)),
		SLOT  (slotSelectItem(QListViewItem *))
	)	;

	connect	(&m_bMoveUp,   SIGNAL(clicked()), SLOT(slotClickMoveUp	())) ;
	connect	(&m_bMoveDown, SIGNAL(clicked()), SLOT(slotClickMoveDown())) ;
	connect	(&m_bAdd,      SIGNAL(clicked()), SLOT(slotClickAdd	())) ;
	connect	(&m_bRemove,   SIGNAL(clicked()), SLOT(slotClickRemove	())) ;
	connect	(&m_bOK,       SIGNAL(clicked()), SLOT(slotClickOK	())) ;
	connect	(&m_bCancel,   SIGNAL(clicked()), SLOT(slotClickCancel	())) ;

	if (m_filterSet.childCount() > 0)
	{
		m_filterSet.firstChild()->setSelected (true) ;
		m_bMoveDown.setEnabled (m_filterSet.childCount() > 1) ;
	}
	else	m_bMoveDown.setEnabled (false) ;

	m_bMoveUp.setEnabled (false) ;
}

/*  KBTableFilterDlg							*/
/*  slotSelectItem							*/
/*		: Item is selected					*/
/*  item	: QListViewItem * : Item in question			*/
/*  (returns)	: void		  :					*/

void	KBTableFilterDlg::slotSelectItem
	(	QListViewItem	*item
	)
{
	bool		first	= false	;
	bool		last	= false	;
	QListViewItem	*iter	= m_filterSet.firstChild() ;

	if (iter == item) first = true  ;

	while (iter != 0)
	{	QListViewItem *next = iter->nextSibling() ;
		if ((iter == item) && (next == 0)) last = true ;
		iter = next ;
	}

	m_bMoveUp  .setEnabled ((m_filterSet.childCount() > 1) && !first) ;
	m_bMoveDown.setEnabled ((m_filterSet.childCount() > 1) && !last ) ;
}

/*  KBTableFilterDlg							*/
/*  slotClickMoveUp							*/
/*		: Move selected entry up				*/
/*  (returns)	: void		:					*/

void	KBTableFilterDlg::slotClickMoveUp ()
{
	QListViewItem	*item = m_filterSet.currentItem() ;
	if (item == 0) return ;

	QListViewItem	*prev = m_filterSet.firstChild () ;
	if ((prev == 0) || (prev == item)) return ;

	while (prev->nextSibling() != 0)
		if (prev->nextSibling()->nextSibling() == item)
			break	;
		else	prev = prev->nextSibling() ;

	if (prev->nextSibling() == 0) prev = 0 ;

	KBFilterLVItem	*move = new KBFilterLVItem
					(	&m_filterSet,
						prev,
						(KBFilterLVItem *)item
					)	;
	delete	item	;
	m_filterSet.setCurrentItem (move)  ;
	slotSelectItem	(move) ;
}

/*  KBTableFilterDlg							*/
/*  slotClickMoveDown							*/
/*		: Move selected entry down				*/
/*  (returns)	: void		:					*/

void	KBTableFilterDlg::slotClickMoveDown ()
{
	QListViewItem	*item = m_filterSet.currentItem() ;
	if (item == 0) return ;

	QListViewItem	*next = item->nextSibling () ;
	if (next == 0) return ;

	KBFilterLVItem	*move = new KBFilterLVItem
					(	&m_filterSet,
						next,
						(KBFilterLVItem *)item
					) ;
	delete	item	;
	m_filterSet.setCurrentItem (move) ;
	slotSelectItem	(move) ;
}

/*  KBTableFilterDlg							*/
/*  slotClickRemove							*/
/*		: Request to remove the current item			*/
/*  (returns)	: void		:					*/

void	KBTableFilterDlg::slotClickRemove ()
{
	QListViewItem	*item	= m_filterSet.currentItem() ;
	if (item != 0) m_filterSet.removeItem (item) ;
}

/*  KBTableFilterDlg							*/
/*  shotClickCancel							*/
/*		: User cancels request					*/
/*  (returns)	: void		:					*/


void	KBTableFilterDlg::slotClickCancel ()
{
	done	(0) ;
}

/*  KBTableFilterDlg							*/
/*  checkOK	: Common checks when user clicks OK			*/
/*  extant	: void *	: Extant filter of same name if any	*/
/*  editing	: void *	: Extant filter being edited if any	*/
/*  (returns)	: bool		: True if OK				*/

bool	KBTableFilterDlg::checkOK
	(	void		*extant,
		void		*editing
	)
{
	if (m_name.text().isEmpty())
	{
		TKMessageBox::sorry
		(	0,
			TR("Please specify a filter name"),
			TR("Table filter")
		)	;
		return	false	;
	}
	if (m_filterSet.childCount() == 0)
	{
		TKMessageBox::sorry
		(	0,
			TR("Please specify at least one column"),
			TR("Table filter")
		)	;
		return	false	;
	}
	if ((extant != 0) && (extant != editing))
	{
		TKMessageBox::sorry
		(	0,
			TR("Filter with this name already exists"),
			TR("Table filter")
		)	;
		return	false	;
	}

	return	true	;
}


/*  ------------------------------------------------------------------  */

/*  KBTableSortDlg							*/
/*  KBTableSortDlg							*/
/*		: Constructor for table sort filter dialog		*/
/*  tableSpec	: KBTableSpec &	 : Table specification			*/
/*  tableInfo	: KBTableInfo *	 : Table information			*/
/*  tableSort	: KBTableSort *& : Sort filter being edited if any	*/
/*  (returns)	: KBTableSortDlg :					*/

KBTableSortDlg::KBTableSortDlg
	(	KBTableSpec	&tableSpec,
		KBTableInfo	*tableInfo,
		KBTableSort	*&tableSort
	)
	:
	KBTableFilterDlg (tableSpec, tableInfo, TR("Sorting")),
	m_columns	 (this),
	m_order		 (this),
	m_tableSort	 (tableSort)
{
	m_layCols->addWidget (&m_columns) ;
	m_layCols->addWidget (&m_order  ) ;

	m_filterSet.addColumn (TR("Column"), 150) ;
	m_filterSet.addColumn (TR("Order" )) ;

	LITER
	(	KBFieldSpec,
		m_tableSpec.m_fldList,
		fSpec,
		m_columns.insertItem (fSpec->m_name)
	)

	m_order.insertItem(TR("Asc ")) ;
	m_order.insertItem(TR("Desc")) ;


	if (m_tableSort != 0)
	{
		m_name.setText (m_tableSort->m_name) ;

		KBFilterLVItem	*last = 0 ;
		bool		asc	  ;

		for (uint idx = 0 ; idx < m_tableSort->m_columns.count() ; idx += 1)
		{
			asc	= m_tableSort->m_orders [idx] ;
			last	= new KBFilterLVItem
				  (	&m_filterSet,
				  	last,
				  	m_tableSort->m_columns[idx],
				  	asc ? TR("Asc") : TR("Desc")
				  )	;

			last->setAsc (asc) ;
		}
	}


#if	__KB_EMBEDDED
	showMaximized () ;
#endif
}


void	KBTableSortDlg::slotClickAdd ()
{
	QListViewItem	*item	= m_filterSet.currentItem() ;

	if (item == 0)
	{	item	= m_filterSet.firstChild() ;
		if (item != 0)
			while (item->nextSibling() != 0)
				item	= item->nextSibling() ;
	}

	KBFilterLVItem	*add	= new KBFilterLVItem
				  (	&m_filterSet,
				  	item,
				  	m_columns.currentText(),
				  	m_order  .currentText()
				  )	;
	add->setAsc (m_order.currentItem() == 0) ;

	m_filterSet.setCurrentItem (add) ;
	slotSelectItem	(add) ;
}

void	KBTableSortDlg::slotClickOK ()
{
	if (!checkOK(m_tableInfo->getSort (m_name.text()), m_tableSort))
		return ;

	if ((m_tableSort == 0) || (m_name.text() != m_tableSort->name()))
		m_tableSort = m_tableInfo->addSort (m_name.text()) ;

	m_tableSort->m_name = m_name.text() ;

	m_tableSort->m_columns.clear() ;
	m_tableSort->m_orders .clear() ;

	KBFilterLVItem *item = (KBFilterLVItem *)m_filterSet.firstChild() ;
	while (item != 0)
	{	
		m_tableSort->m_columns.append(item->text(0)) ;
		m_tableSort->m_orders .append(item->asc  ()) ;
		item	= (KBFilterLVItem *)item->nextSibling() ;
	}

	done	(1) ;
}

/*  ------------------------------------------------------------------  */

/*  KBTableSelectDlg							*/
/*  KBTableSelectDlg							*/
/*		: Constructor for table select filter dialog		*/
/*  tableSpec	: KBTableSpec &	   : Table specification		*/
/*  tableInfo	: KBTableInfo *	   : Table information			*/
/*  tableSelect	: KBTableSelect *& : Select filter being edited if any	*/
/*  (returns)	: KBTableSelectDlg :					*/

KBTableSelectDlg::KBTableSelectDlg
	(	KBTableSpec	&tableSpec,
		KBTableInfo	*tableInfo,
		KBTableSelect	*&tableSelect
	)
	:
	KBTableFilterDlg (tableSpec, tableInfo, TR("Selection")),
	m_columns	 (this),
	m_oper		 (this),
	m_value		 (this),
	m_tableSelect	 (tableSelect)
{
	m_layCols->addWidget (&m_columns) ;
	m_layCols->addWidget (&m_oper   ) ;
	m_layCols->addWidget (&m_value  ) ;

	m_filterSet.addColumn (TR("Column"   ), 150) ;
	m_filterSet.addColumn (TR("Operator" ), 50 ) ;
	m_filterSet.addColumn (TR("Value"   )) ;


	LITER
	(	KBFieldSpec,
		m_tableSpec.m_fldList,
		fSpec,
		m_columns.insertItem (fSpec->m_name)
	)

	static	cchar	*opname[] =
	{	"=",
		"!=",
		">",
		">=",
		"<",
		"<=",
		"like",
		"not null"
	}	;

	for (cchar **op = &opname[0] ; *op != 0 ; op += 1)
		m_oper.insertItem(TR(*op)) ;

	if (m_tableSelect != 0)
	{
		m_name.setText (m_tableSelect->m_name) ;

		KBFilterLVItem		*last = 0 ;
		KBTableSelect::Operator	oper	  ;

		for (uint idx = 0 ; idx < m_tableSelect->m_columns.count() ; idx += 1)
		{
			oper	= m_tableSelect->m_operators[idx] ;
			last	= new KBFilterLVItem
				  (	&m_filterSet,
				  	last,
				  	m_tableSelect->m_columns[idx],
				  	opname[oper],
				  	m_tableSelect->m_values [idx]
				  )	;

			last->setOper (oper) ;
		}
	}


#if	__KB_EMBEDDED
	showMaximized () ;
#endif
}


void	KBTableSelectDlg::slotClickAdd ()
{
	QListViewItem	*item	= m_filterSet.currentItem() ;
	bool		nullop	= (m_oper.currentItem() == KBTableSelect::NotNull) ||
				  (m_oper.currentItem() == KBTableSelect::IsNull ) ;

	if (!nullop &&  m_value.text().isEmpty())
	{
		TKMessageBox::sorry
		(	0,
			TR("Please specify a value"),
			TR("Select filter")
		)	;
		return	;
	}
	if ( nullop && !m_value.text().isEmpty())
	{
		TKMessageBox::sorry
		(	0,
			TR("No value needed for (is) not null"),
			TR("Select filter")
		)	;
		return	;
	}

	if (item == 0)
	{	item	= m_filterSet.firstChild() ;
		if (item != 0)
			while (item->nextSibling() != 0)
				item	= item->nextSibling() ;
	}

	KBFilterLVItem	*add	= new KBFilterLVItem
				  (	&m_filterSet,
				  	item,
				  	m_columns.currentText(),
				  	m_oper   .currentText(),
				  	m_value  .text()
				  )	;
	add->setOper ((KBTableSelect::Operator)m_oper.currentItem()) ;

	m_filterSet.setCurrentItem (add) ;
	slotSelectItem	(add) ;
}

void	KBTableSelectDlg::slotClickOK ()
{
	if (!checkOK(m_tableInfo->getSelect (m_name.text()), m_tableSelect))
		return ;

	if ((m_tableSelect == 0) || (m_name.text() != m_tableSelect->name()))
		m_tableSelect = m_tableInfo->addSelect (m_name.text()) ;

	m_tableSelect->m_name = m_name.text() ;

	m_tableSelect->m_columns  .clear() ;
	m_tableSelect->m_operators.clear() ;
	m_tableSelect->m_values   .clear() ;

	KBFilterLVItem *item = (KBFilterLVItem *)m_filterSet.firstChild() ;
	while (item != 0)
	{	
		m_tableSelect->m_columns  .append(item->text(0)) ;
		m_tableSelect->m_operators.append(item->oper( )) ;
		m_tableSelect->m_values   .append(item->text(2)) ;
		item	= (KBFilterLVItem *)item->nextSibling () ;
	}

	done	(1) ;
}

/*  ------------------------------------------------------------------  */

/*  KBTableViewDlg							*/
/*  KBTableViewDlg							*/
/*		: Constructor for table view filter dialog		*/
/*  tableSpec	: KBTableSpec &	  : Table specification			*/
/*  tableInfo	: KBTableInfo *	  : Table information			*/
/*  tableSelect	: KBTableView *&  : View filter being edited if any	*/
/*  (returns)	: KBTableViewtDlg :					*/

KBTableViewDlg::KBTableViewDlg
	(	KBTableSpec	&tableSpec,
		KBTableInfo	*tableInfo,
		KBTableView	*&tableView
	)
	:
	KBTableFilterDlg (tableSpec, tableInfo, TR("Columns")),
	m_columns	 (this),
	m_tableView	 (tableView)
{
	m_layCols->addWidget (&m_columns) ;

	m_filterSet.addColumn (TR("Column"   ), 150) ;

	LITER
	(	KBFieldSpec,
		m_tableSpec.m_fldList,
		fSpec,
		m_columns.insertItem (fSpec->m_name)
	)

	if (m_tableView != 0)
	{
		m_name.setText (m_tableView->m_name) ;

		KBFilterLVItem	*last = 0 ;

		for (uint idx = 0 ; idx < m_tableView->m_columns.count() ; idx += 1)
		{
			last	= new KBFilterLVItem
				  (	&m_filterSet,
				  	last,
				  	m_tableView->m_columns[idx]
				  )	;
		}
	}

#if	__KB_EMBEDDED
	showMaximized () ;
#endif
}


void	KBTableViewDlg::slotClickAdd ()
{
	QListViewItem	*item	= m_filterSet.currentItem() ;

	if (item == 0)
	{	item	= m_filterSet.firstChild() ;
		if (item != 0)
			while (item->nextSibling() != 0)
				item	= item->nextSibling() ;
	}

	KBFilterLVItem	*add = new KBFilterLVItem
				   (	&m_filterSet,
				  	item,
				  	m_columns.currentText()
				   )	;

	m_filterSet.setCurrentItem (add) ;
	slotSelectItem	(add) ;
}

void	KBTableViewDlg::slotClickOK ()
{
	if (!checkOK(m_tableInfo->getView (m_name.text()), m_tableView))
		return ;

	if ((m_tableView == 0) || (m_name.text() != m_tableView->name()))
		m_tableView = m_tableInfo->addView (m_name.text()) ;

	m_tableView->m_name = m_name.text() ;

	m_tableView->m_columns.clear() ;

	KBFilterLVItem *item = (KBFilterLVItem *)m_filterSet.firstChild() ;
	while (item != 0)
	{	
		m_tableView->m_columns.append(item->text(0)) ;
		item	= (KBFilterLVItem *)item->nextSibling() ;
	}

	done	(1) ;
}
