/***************************************************************************
    file	         : kb_tablefilterdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_TABLEFILTERDLG_H
#define	__KB_TABLEFILTERDLG_H


#include	<qlistview.h>
#include	<qcombobox.h>
#include	<qpushbutton.h>
#include	<qlineedit.h>
#include	<qlabel.h>
#include	<qlayout.h>

#include	"kb_classes.h"
#include	"kb_dialog.h"
#include	"kb_tableinfo.h"


class	KBTableSpec	;
class	KBTableSort	;
class	KBTableSelect	;
class	KBTableView	;


/*  KBTableFilterDlg							*/
/*  ----------------							*/
/*  This is the base class for the dialogs used to edit filter sort,	*/
/*  order and view sets.						*/

class	KBTableFilterDlg : public _KBDialog
{
	Q_OBJECT

protected :

	QLabel		m_label		;
	QLineEdit	m_name		;

	QListView	m_filterSet	;

	QPushButton	m_bMoveUp	;
	QPushButton	m_bMoveDown	;
	QPushButton	m_bAdd		;
	QPushButton	m_bRemove	;
	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;

	QHBoxLayout	*m_layCols	;

	KBTableSpec	&m_tableSpec	;
	KBTableInfo	*m_tableInfo	;

	bool		checkOK			(void *,  void *) ;

protected slots :

	void		slotSelectItem		(QListViewItem *) ;

	void		slotClickMoveUp		() ;
	void		slotClickMoveDown	() ;
	void		slotClickRemove		() ;
	void		slotClickCancel		() ;

	virtual	void	slotClickAdd		() = 0 ;
	virtual	void	slotClickOK		() = 0 ;

public	:

	KBTableFilterDlg
	(	KBTableSpec	&,
		KBTableInfo	*,
		const QString	&
	)	;
}	;


/*  KBTableSortDlg							*/
/*  --------------							*/
/*  Dialog for table sorting						*/

class	KBTableSortDlg : public KBTableFilterDlg
{
	Q_OBJECT

	QComboBox	m_columns	;
	QComboBox	m_order		;

	KBTableSort	*&m_tableSort	;

public	:

	KBTableSortDlg
	(	KBTableSpec	&,
		KBTableInfo	*,
		KBTableSort	*&
	) ;

protected slots :

	virtual	void	slotClickAdd		()  ;
	virtual	void	slotClickOK		()  ;
}	;


/*  KBTableSelectDlg							*/
/*  --------------							*/
/*  Dialog for table sorting						*/

class	KBTableSelectDlg : public KBTableFilterDlg
{
	Q_OBJECT

	QComboBox	m_columns	;
	QComboBox	m_oper		;
	QLineEdit	m_value		;

	KBTableSelect	*&m_tableSelect	;

public	:

	KBTableSelectDlg
	(	KBTableSpec	&,
		KBTableInfo	*,
		KBTableSelect	*&
	) ;

protected slots :

	virtual	void	slotClickAdd		()  ;
	virtual	void	slotClickOK		()  ;
}	;


/*  KBTableViewDlg							*/
/*  --------------							*/
/*  Dialog for table sorting						*/

class	KBTableViewDlg : public KBTableFilterDlg
{
	Q_OBJECT

	QComboBox	m_columns	;

	KBTableView	*&m_tableView	;

public	:

	KBTableViewDlg
	(	KBTableSpec	&,
		KBTableInfo	*,
		KBTableView	*&
	) ;

protected slots :

	virtual	void	slotClickAdd		()  ;
	virtual	void	slotClickOK		()  ;
}	;


#endif	// __KB_TABLEFILTERDLG_H
