/***************************************************************************
    file	         : kb_tableviewer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_TABLEVIEWER_H
#define  _KB_TABLEVIEWER_H


#include	"kb_classes.h"
#include	"kb_viewer.h"
#include	"kb_navgui.h"


/*  KBTableViewer							*/
/*  -------------							*/
/*  This class is used to directly view tables, either in design or	*/
/*  data mode. Note that design mode is table definition, rather than	*/
/*  form design on the table design form!				*/

class	KBTableViewer : public KBViewer
{
	Q_OBJECT

	bool		m_create	;
	KBAttrStr	*m_ident	;
	KBForm		*m_docRoot	;
	KBQryDesign	*m_qryRoot	;
	KB::ShowAs	m_showing	;

	KBNavGUI	*m_dataGUI	;
	bool		m_byExpr	;

#if	! __KB_RUNTIME
	KBaseGUI	*m_designGUI	;
#endif

	TKActionMenu	*m_sortSet	;
	TKActionMenu	*m_selectSet	;
	TKActionMenu	*m_viewSet	;
	QList<TKAction>	m_filtering	;
	QDict<KBType>	m_typeMap	;
	QString		m_currSort	;
	QString		m_currSelect	;


	KB::ShowRC	showView	(KBForm *, KBError &) ;
	KB::ShowRC	showDesign	(KBError &) ;
	KB::ShowRC	showData	(KBError &) ;

	void		checkToggle	(TKActionMenu *, TKAction *) ;
	void		buildFilterMenu	(TKActionMenu *, const QStringList &, const QString &, cchar *) ;
	void		buildFilterMenu	() ;

protected slots :

	void		editFilters	() ;
	void		applySort	() ;
	void		applySelect	() ;
	void		applyView	() ;
	void		focusAtRow	(bool, uint, uint, bool) ;

public	:

		 KBTableViewer	(KBObjBase *, QWidget *, bool) ;
	virtual	~KBTableViewer	() ;


	KB::ShowRC		startup	(bool, KB::ShowAs, KBError &) ;


	virtual	KBTableViewer	*isTableViewer 	() { return this ; }
	virtual	cchar		*getChanged     	(bool) ;

#if	__KB_KDE
	virtual	KAction 	*action	      	(const QDomElement &) const ;
#endif
#if	__KB_TKC
	virtual	TKAction 	*action	      	(const QDomElement &) const ;
#endif

public	slots	:

	virtual void	showAs		(KB::ShowAs)	;

	void		saveDocument	()	;
	void		saveDocumentAs	()	;
	void		dbaseAction	(int)	;
	void		reload		()	;
	void		orderByExpr	()	;
}	;

#endif // _KB_TABLEVIEWER_H
