/***************************************************************************
    file	         : kb_tablelist.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_TABLELIST_H
#define	_KB_TABLELIST_H


#include 	<qfile.h>


#include	"kb_database.h"
#include	"kb_listitem.h"
#include	"kb_filelist.h"

#include 	"kb_dom.h"



class	KBTableList	;
class	KBServerItem	;
class	KBTableItem	;


/*  KBTableItem								*/
/*  -----------								*/
/*  Derived class from KBObjectItem, used for table entries in the	*/
/*  table list display, used to retain a pointer to the	KBTableList	*/
/*  dialog in which it is embedded, and to handle open/close of the	*/
/*  branch of the list view.						*/

class	KBTableItem : public KBObjectItem
{
	KBTableList	*m_tabList ;

public	:

	KBTableItem
	(	KBServerItem 	*,
		const QString	&,
		KBTableList	*,
		const QString	&,
		const QString	& = QString::null
	)	;

	virtual	void	setOpen (bool) ;
}	;


/*  KBTableList								*/
/*  -----------								*/
/*  Widget used to list all tables in the database, grouped up by	*/
/*  server.								*/

class	KBTableList : public KBFileList
{
	Q_OBJECT

	int		dblClick  ;

	virtual void	showObjectAs	(KBListItem   *, KB::ShowAs) ;
	void		createTable	(KBServerItem *) ;

	bool		getExportFile	(QFile    &, const QString &)	;
	bool		getTableDef	(KBDBLink &, const QString &, QDomElement &) ;

	virtual void	reloadServer	(KBServerItem *) ;

protected :

	virtual	void	showServerMenu	()	;
	virtual	void	showObjectMenu	()	;

protected slots :

	virtual	void	showDefault	(QListViewItem *) ;
	void		renameTable	()	  ;
	void		deleteTable	()	  ;
	void		createTable	()	  ;

	void		exportTable	()	  ;
	void		exportAllTables	()	  ;
	void		importTables	()	  ;
	void		showTableInfo	()	  ;

	void		serverChanged	(const KBLocation &) ;
	void		tablesChanged	(const KBLocation &) ;

public	:

	KBTableList (QWidget *, KBDBInfo *) ;
       ~KBTableList () ;

	inline	KBDBInfo *getDBInfo	() { return m_dbInfo	 ; }
	inline	bool	 inDblClick	() { return dblClick > 0 ; }

	virtual	QStringList	getObjectNames	(KBServerInfo *) ;

protected :

	virtual	void	contentsMouseDoubleClickEvent (QMouseEvent *) ;

	friend	class	KBServerItem	;
}	;

#endif	// _KB_TABLELIST_H
