/***************************************************************************
    file	         : kb_conductor.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<unistd.h>
#include	<errno.h>

#include	<qapp.h>
#include	<qtimer.h>
#include	<qfile.h>
#include	<qpixmap.h>
#include	<qmessagebox.h>

#include	<kapp.h>
#include	<kconfig.h>
#include	<klocale.h>
#include	<kaboutdata.h>
#include	<kcmdlineargs.h>


#include	"kb_conductor.moc"
#include	"kb_object.h"


/*  KBConductorDlg							*/
/*  KBConductorDlg							*/
/*		: Constructor for conductor dialog			*/
/*  (returns)	: KBConductorDlg :					*/

KBConductorDlg::KBConductorDlg ()
	:
	QDialog		(0, "conductordlg", true,
					    WDestructiveClose|
					    WStyle_Customize |
					    WStyle_StaysOnTop|
					    WStyle_NormalBorder
			),
	m_browser	(this),
	m_lSeq		(this),
	m_cMode		(this),
	m_bContinue	(this),
	m_bCancel	(this)
{
	m_layMain	= new QVBoxLayout (this) ;
	m_layMain   ->addWidget (&m_browser) ;
	m_layMain   ->setMargin (4) ;
	m_layMain   ->setSpacing(4) ;

	m_layButtons	= new QHBoxLayout (m_layMain) ;
	m_layButtons->addWidget (&m_lSeq     ) ;
	m_layButtons->addStretch()  ;
	m_layButtons->addWidget (&m_cMode    ) ;
	m_layButtons->addWidget (&m_bContinue) ;
	m_layButtons->addWidget (&m_bCancel  ) ;
	m_layButtons->setMargin (4) ;
	m_layButtons->setSpacing(4) ;

	m_cMode	   .insertItem  (TR("Step"	)) ;
	m_cMode	   .insertItem  (TR("Group"	)) ;
	m_cMode	   .insertItem  (TR("Continuous")) ;

	m_bContinue.setText	(TR("Continue"  )) ;
	m_bCancel  .setText	(TR("Cancel"    )) ;

	connect (&m_cMode,     SIGNAL(activated(int)),	SLOT(changeMode   ())) ;
	connect	(&m_bContinue, SIGNAL(clicked()), 	SLOT(clickContinue())) ;
	connect	(&m_bCancel,   SIGNAL(clicked()),	SLOT(clickCancel  ())) ;

	m_socket.setSocket (0) ;
	connect	(&m_socket,   SIGNAL(connectionClosed()), SLOT(slotLinkClosed ())) ;
	connect	(&m_socket,   SIGNAL(readyRead	     ()), SLOT(slotReadyRead  ())) ;

	m_bContinue.setEnabled	(false) ;
	m_pause	= false	;
	m_len	= 0	;
	m_msg	= 0	;

	m_browser.setTextFormat  (Qt::RichText) ;
	m_cMode	 .setCurrentItem (1) ;

	setCaption	("Rekall Score Player") ;
	setMinimumSize	(600, 280) ;
	show		() ;

}

/*  KBConductorDlg							*/
/*  ~KBConductorDlg							*/
/*		: Destructor for conductor dialog			*/
/*  (returns)	:		:					*/

KBConductorDlg::~KBConductorDlg ()
{
}

/*  KBConductorDlg							*/
/*  clickContinue: User clicks continue button				*/
/*  (returns)	 : void		:					*/

void	KBConductorDlg::clickContinue ()
{
	if (m_pause)
	{
		m_bContinue.setEnabled (false) ;
		m_bContinue.setText    (TR("Continue")) ;

		write	(1, "_", 1) ;
		m_pause	= false	    ;
	}
}

/*  KBConductorDlg							*/
/*  changeMode	: Used changes execution mode				*/
/*  (returns)	: void		:					*/

void	KBConductorDlg::changeMode ()
{
	switch (m_cMode.currentItem())
	{
		case 0	:
			/* Single stepping ...				*/
			m_bContinue.setEnabled (m_pause) ;
			break	;

		case 1	:
			/* Run by group ...				*/
			m_bContinue.setEnabled (m_pause) ;
			break	;

		case 2 :
			/* Continuous operation ...			*/
			m_bContinue.setEnabled (false) ;

			if (m_pause)
			{	write	(1, "_", 1) ;
				m_pause	= false	    ;
			}

			break	;

		default	:
			break	;
	}
}

/*  KBConductorDlg							*/
/*  clickCancel	: User clicks continue button				*/
/*  (returns)	: void		:					*/

void	KBConductorDlg::clickCancel ()
{
	_exit	(0) ;
}

void	KBConductorDlg::slotReadyRead ()
{
	if (m_len == 0)
	{
		if (m_socket.readBlock ((char *)&m_len, sizeof(m_len)) != sizeof(m_len))
		{	fprintf	(stderr, "readBlock for length failed\n") ;
			_exit	(0) ;
		}

		if (m_msg != 0) free ((void *)m_msg) ;

		m_got = 0 ;
		m_msg = (MsgBuff *)malloc(sizeof(uint) + m_len + 1) ;
		m_msg->len = m_len    ;
	}

	int	got	= m_socket.readBlock (&((char *)m_msg)[m_got + sizeof(uint)], m_len - m_got) ;

	if (got < 0)
	{	fprintf	(stderr, "readBlock for data %d failed\n", m_len) ;
		_exit	(0) ;
	}

	if ((m_got += got) < m_len)
		return	;

//	fprintf
//	(	stderr,
//		"Conductor: len=%d code=%c(%d) seq=%d msg=%.20s\n",
//		m_len,
//		m_msg->code,
//		m_msg->code,
//		m_msg->seq,
//		m_msg->buff
//	)	;

	m_lSeq.setText (QString("%1").arg(m_msg->seq)) ;

	switch (m_msg->code)
	{
		case 'I' :
			/* Initialisation at start of script.	*/
			m_cMode.setCurrentItem  (1) ;
			m_bContinue.setEnabled	(true) ;
			m_pause	= false	;
			write	(1, "_", 1) ;
			break	;

		case 'M' :
			/* Message. This is displayed, and we	*/
			/* pause unless in continuous mode.	*/
			if (m_msg->buff[0] != 0)
				m_browser.setText (m_msg->buff) ;

			if (m_cMode.currentItem() == 2)
			{
				write	(1, "_", 1) ;
				break	;
			}

			m_bContinue .setEnabled (true) ;
			m_pause	= true	;
			break	;

		case 'R' :
			/* Rekall ready for next stage. If	*/
			/* single stepping then pause, else	*/
			/* just rock on.			*/
			if (m_cMode.currentItem() == 0)
			{
				m_bContinue.setEnabled (true) ;
				m_pause	= true	;
				break	;
			}

			write	(1, "_", 1) ;
			break	;

		case 'S' :
			/* Rekall is about to do a snapshot.	*/
			/* Pause with the continue button re-	*/
			/* labelled.				*/
			m_bContinue.setEnabled (true) ;
			m_bContinue.setText    (TR("Snapshot")) ;
			m_pause	= true	;
			break	;

		default	 :
			break	;
	}

	m_len	= 0	;
}

void	KBConductorDlg::slotLinkClosed ()
{
	_exit	(0) ;
}


/*  ------------------------------------------------------------------  */

static	const	KCmdLineOptions	options[] =
{
	{	0,		0,				0	}
}	;

int	main
	(	int	argc,
		char	*argv[]
	)
{
	KAboutData about ("rekallCon",
			  I18N_NOOP("RekallCon"),
			  "1.0",
			  I18N_NOOP("Score conductor for Rekall"),
			  KAboutData::License_Unknown,
			  "(c) 2001 by Mike Richardson",
			  "(c) 2001 by theKompany.com"
			 ) ;
	about.addAuthor  ("Mike Richardson", 0, "mike@quaking.demon.co.uk") ; 

	KCmdLineArgs::init		(argc, argv, &about) ;
	KCmdLineArgs::addCmdLineOptions (options) ;

	KApplication app   	 (argc, argv) ;
	KCmdLineArgs::parsedArgs () ;

	freopen	("/dev/tty", "w", stderr) ;

	app.setMainWidget (new KBConductorDlg ()) ;
	return	app.exec  () ;
}
