/***************************************************************************
    file	         : kb_kjsregister.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_KJSREGISTER_H
#define	__KB_KJSREGISTER_H

#include	"kb_classes.h"

class	KBObjectProxy	;

typedef	KBObjectProxy	*MKFUNC	(KJS::Interpreter *, KBNode *) ;


/*  KBKJSRegister							*/
/*  -------------							*/
/*  Static instances of this class are created in order to create	*/
/*  mappings from rekall object types (KBBlock, KBButton, etc) to	*/
/*  factory function that create the appropriate KJS proxy classes for	*/
/*  them.								*/

class	KBKJSRegister
{
	KBKJSRegister	*m_next		;
	cchar		*m_kbname	;
	MKFUNC		*m_mkFunc	;
	cchar		**m_aliases	;

public	:

	KBKJSRegister	(cchar *, MKFUNC *, cchar ** = 0) ;

	KBKJSRegister	*doRegister () ;
}	;

extern	KBObjectProxy	*makeProxy	(KJS::Interpreter *, KBNode *) ;
extern	void		registerClasses	() ;

#endif	// __KB_KJSREGISTER_H
