/***************************************************************************
    file	         : kb_objectproxy.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<kjs/global.h>
#include	<kjs/interpreter.h>
#include	<kjs/lookup.h>
#include	<kjs/object.h>
#include	<kjs/operations.h>
#include	<kjs/types.h>
#include	<kjs/ustring.h>
#include	<kjs/value.h>


#include	"kb_classes.h"
#include	"kb_object.h"
#include	"kb_config.h"

#include	"kb_idbase.h"
#include	"kb_objectproxy.h"
#include	"kb_kjsregister.h"


extern	QString kjsStringArg	(KJS::ExecState *, const KJS::List &, int) ;


/*  KBObjectProxy							*/
/*  KBObjectProxy: Constructor for rekall object proxy			*/
/*  interp	 : KJS::Interpreter *	: Intepreter object		*/
/*  object	 : KBObject *		: Rekall object			*/
/*  (returns)	 : KBObjectProxy	:				*/

KBObjectProxy::KBObjectProxy
	(	KJS::Interpreter	*interp,
		KBObject		*object
	)
	:
	KJS::ObjectImp	(),
	m_interp	(interp),
	m_object	(object)
{
}

/*  KBObjectProxy							*/
/* ~KBObjectProxy: Destructor for rekall object proxy			*/
/*  (returns)	 :		:					*/

KBObjectProxy::~KBObjectProxy ()
{
}

/*  KBObjectProxy							*/
/*  addBindings	: Add proxy bindings to specified object		*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  object	: KJS::Object &		: Object to which to add	*/
/*  (returns)	: void			:				*/

void	KBObjectProxy::addBindings
	(	KJS::ExecState	*,
		KJS::Object	&object
	)
{
	static	struct	MethodSpec
	{	cchar		*name	;
		uint		id	;
	}
		methods	[] =
		{
			{	"getAttr",	MethodImp::id_getAttr		},
			{	"getConfig",	MethodImp::id_getConfig		},
			{	"setAttr",	MethodImp::id_setAttr		},
			{	"resize",	MethodImp::id_resize		},
			{	"getNamedCtrl",	MethodImp::id_getNamedCtrl	},
			{	0,		0				}
		}	;

	for (MethodSpec *ms = &methods[0] ; ms->name != 0 ; ms += 1)
		object.put
		(	m_interp->globalExec(),
			ms->name,
			KJS::Object(new MethodImp(ms->id, this))
		)	;
}

/*  KBObjectProxy							*/
/*  get		: Get property value					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  property	: constKJS::UString &	: Property name			*/
/*  (returns)	: KJS::Value		: Result			*/

KJS::Value
	KBObjectProxy::get
	(	KJS::ExecState		*exec,
		const KJS::UString	&property
	)
	const
{
	QString	p = property.qstring() ;

	if (p == "name"   )
		return	KJS::String(m_object->getName   ()) ;

	if (p == "type"   )
		return	KJS::String(m_object->getElement()) ;

	if (p == "enabled")
		return	KJS::Number(m_object->isEnabled ()) ;

	if (p == "visible")
		return	KJS::Number(m_object->isVisible ()) ;

	if (p == "width"  )
		return	KJS::Number(m_object->geometry().width ()) ;

	if (p == "height" )
		return	KJS::Number(m_object->geometry().height()) ;

	return	KJS::ObjectImp::get (exec, property) ;
}

/*  KBObjectProxy							*/
/*  put		: Set property value					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  property	: const KJS::UString &	: Property name			*/
/*  value	: const KJS::Value &	: Value				*/
/*  attr	: int			:				*/
/*  (returns)	: void			:				*/

void	KBObjectProxy::put
	(	KJS::ExecState		*exec,
		const KJS::UString	&property,
		const KJS::Value	&value,
		int			attr
	)
{
	QString	p = property.qstring() ;

	if (p == "enabled")
	{
		((KBObject *)m_object)->setEnabled (value.toBoolean(exec)) ;
		return	;
	}

	if (p == "visible")
	{
		((KBObject *)m_object)->setVisible (value.toBoolean(exec)) ;
		return	;
	}

	KJS::ObjectImp::put (exec, property, value, attr) ;
}


/*  ------------------------------------------------------------------  */

/*  KBObjectProxy							*/
/*  MethodImp	: 							*/
/*  MethodImp	: Object implementation					*/
/*  id		: uint		  : Method identifier			*/
/*  object	: KBObjectProxy * : Associated proxy			*/
/*  (return)	: MethodImp	  :					*/

KBObjectProxy::MethodImp::MethodImp
	(	uint			id,
		const KBObjectProxy	*object
	)
	:
	KJS::ObjectImp	(),
	m_id		(id),
	m_object	(object)
{
}


/*  MethodImp								*/
/*  call	: Invoke a method					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  obj		: KJS::Object &		: Apparently "self"		*/
/*  args	: const KJS::List	: Argument list			*/
/*  (returns)	: KJS::Value		: Result			*/

KJS::Value
	KBObjectProxy::MethodImp::call
	(	KJS::ExecState		*exec,
		KJS::Object		&,
		const KJS::List		&args
	)
{
	switch (m_id)
	{
		case id_getAttr		:
			return	KJS::String(m_object->m_object->getAttrVal(kjsStringArg (exec, args, 0))) ;

		case id_getConfig	:
			{
			QString	name	= kjsStringArg (exec, args, 0) ;
			TITER
			(	Config,
				m_object->m_object->getChildren(),
				c,
				if (c->getAttrib() == name)
					return	KJS::String(c->getValue()) ;
			)
			}
			return	KJS::String(QString::null) ;

		case id_setAttr		:
			{
			QString	name	= kjsStringArg (exec, args, 0) ;
			QString	value	= kjsStringArg (exec, args, 1) ;
			m_object->m_object->setAttrVal (name, value) ;
			}
			return	KJS::Null() ;

		case id_resize		:
			m_object->m_object->resize
				(	args.at(0).toInteger(exec),
					args.at(1).toInteger(exec)
				)	;
			return	KJS::Null() ;

		case id_getNamedCtrl	:
			{
			KBObject *obj = m_object->m_object->getNamedObject
					(	kjsStringArg (exec, args, 0),
						args.at(1).toBoolean (exec)
					)	;

			if (obj == 0) return KJS::Null() ;

			KBObjectProxy *proxy = makeProxy (exec->interpreter(), obj) ;
			KJS::Object   object (proxy) ;
			proxy->addBindings   (exec, object) ;
			return	object ;
			}

		default	:
			break	;
	}

	return	KJS::Number(-1)	;
}


KBObjectProxy
	*makeObjectProxy
	(	KJS::Interpreter	*interp,
		KBNode			*node
	)
{
	return	new KBObjectProxy (interp, (KBObject *)node) ;
}

static	KBKJSRegister	_objectReg ("KBObject", makeObjectProxy) ;
