/***************************************************************************
    file	         : pygrid.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYGRID_H
#define	__KB_PYGRID_H

#include	"kb_grid.h"
#include	"pyobject.h"

class	PyKBGrid : public PyKBObject
{
public	:

	inline	PyKBGrid
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBObject (_cookie, _ptr, _name)
	{
	}

	inline	void	getItems
		(	QList<KBItem>	&ilist
		)
	{
		if (!isValid()) return ;
		((KBGrid *)ptr)->getItems (ilist) ;
	}

	inline	void	setOrder
		(	QList<KBItem>	&ilist
		)
	{
		if (!isValid()) return ;
		((KBGrid *)ptr)->setOrder (ilist) ;
	}

	inline	void	setColumnWidth
		(	PyKBItem	*_item,
			uint		width
		)
	{
		if (!isValid()) return ;
		KBItem	*item = (KBItem *)_item->getPtr() ;
		if (item == 0) return ;
		((KBGrid *)ptr)->setColumnWidth (item, width) ;
	}
}	;

#endif	// __KB_PYGRID_H
