/***************************************************************************
    file	         : pysqlupdate.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYSQLUPDATE_H
#define	__KB_PYSQLUPDATE_H

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"pybase.h"

class	PyKBSQLUpdate : public PyKBBase
{
public	:

	inline	PyKBSQLUpdate
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBBase (_cookie, _ptr, _name)
	{
	}

	inline	~PyKBSQLUpdate ()
	{
		KBSQLUpdate *SQLUpdate = (KBSQLUpdate *)getPtr() ;
		if (SQLUpdate != 0) delete SQLUpdate ;
	}

	inline	bool	execute
		(	uint		nVals,
			const KBValue	*values
		)
	{
		KBSQLUpdate *SQLUpdate = (KBSQLUpdate *)getPtr() ;
		if (SQLUpdate == 0) return false ;

		return	SQLUpdate->execute (nVals, values) ;
	}

	inline	uint	getNumRows ()
	{
		KBSQLUpdate *SQLUpdate = (KBSQLUpdate *)getPtr() ;
		return	SQLUpdate == 0 ? 0 : SQLUpdate->getNumRows() ;
	}

	inline	cchar	*lastError ()
	{
		return	PyKBBase::lastError ((KBSQLUpdate *)getPtr()) ;
	}
}	;

#endif	// __KB_PYSQLUPDATE_H
