/***************************************************************************
    file	         : pyitem.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYITEM_H
#define	__KB_PYITEM_H

#include	"kb_object.h"
#include	"pyobject.h"

class	PyKBItem : public PyKBObject
{
public	:

	inline	PyKBItem
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBObject (_cookie, _ptr, _name)
	{
	}

	inline	void	setValue
		(	uint		row,
			const KBValue	&value
		)
	{
		if (!isValid()) return ;
		((KBItem *)ptr)->setValue (row, value) ;
	}

	inline	void	setValue
		(	uint	row,
			cchar	*text,
			uint	len
		)
	{
		if (!isValid()) return ;
		KBItem	*item	= (KBItem *)ptr ;
		KBType	*type	= item->getFieldType() ;

		/* We use the field type for the value, but if this is	*/
		/* undefined then choose a type based on the text	*/
		/* itself.						*/
		bool	ok	;
		if (type->getIType() == KB::ITUnknown)
			if	(QString(text).toInt   (&ok), ok) type = &_kbFixed  ;
			else if (QString(text).toDouble(&ok), ok) type = &_kbFloat  ;
			else					  type = &_kbString ;

//		fprintf
//		(	stderr,
//			"PyKBItem::setValue: [%.*s] [%s]->[%s]\n",
//			len > 16 ? 16 : len,
//			text,
//			(cchar *)item->getFieldType()->getDescrip(),
//			(cchar *)type->		       getDescrip()
//		)	;

		item->setValue (row, KBValue(text, len, type)) ;
	}

	inline	cchar	*getValue
		(	uint	row
		)
	{
		static QString aQString	   ;
		if (!isValid ()) return "" ;
		aQString = ((KBItem *)ptr)->getValue(row).getRawText () ;
		return	aQString ;
	}

	inline	cchar	*getRowValue
		(	uint	row
		)
	{
		static QString aQString	   ;
		if (!isValid ()) return "" ;
		aQString = ((KBItem *)ptr)->getRowValue(row).getRawText () ;
		return	aQString ;
	}

	inline	void	setTabOrder
		(	uint	order
		)
	{
		if (!isValid ()) return ;
		((KBItem *)ptr)->setTabOrder (order) ;
	}

	inline	void	setEnabled
		(	uint	row,
			bool	enabled
		)
	{
		if (!isValid ()) return ;
		((KBItem *)ptr)->setEnabled (row, enabled) ;
	}

	inline	void	setVisible
		(	uint	row,
			bool	visible
		)
	{
		if (!isValid ()) return ;
		((KBItem *)ptr)->setVisible (row, visible) ;
	}

	inline	bool	isVisible
		(	uint	row
		)
	{
		if (!isValid ()) return false ;
		return	((KBItem *)ptr)->isVisible (row) ;
	}

	inline	bool	isEnabled
		(	uint	row
		)
	{
		if (!isValid ()) return false ;
		return	((KBItem *)ptr)->isEnabled (row) ;
	}

	inline	KBItem	*getItem ()
	{
		return	(KBItem *)ptr ;
	}
}	;

#endif	// __KB_PYITEM_H
