/***************************************************************************
    file	         : pysqlinsert.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYSQLINSERT_H
#define	__KB_PYSQLINSERT_H

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"pybase.h"

class	PyKBSQLInsert : public PyKBBase
{
public	:

	inline	PyKBSQLInsert
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBBase (_cookie, _ptr, _name)
	{
	}

	inline	~PyKBSQLInsert ()
	{
		KBSQLInsert *SQLInsert = (KBSQLInsert *)getPtr() ;
		if (SQLInsert != 0) delete SQLInsert ;
	}

	inline	bool	execute
		(	uint		nVals,
			const KBValue	*values
		)
	{
		KBSQLInsert *SQLInsert = (KBSQLInsert *)getPtr() ;
		if (SQLInsert == 0) return false ;

		return	SQLInsert->execute (nVals, values) ;
	}

	inline	uint	getNumRows ()
	{
		KBSQLInsert *SQLInsert = (KBSQLInsert *)getPtr() ;
		return	SQLInsert == 0 ? 0 : SQLInsert->getNumRows() ;
	}

	inline	cchar	*lastError ()
	{
		return	PyKBBase::lastError ((KBSQLInsert *)getPtr()) ;
	}
}	;

#endif	// __KB_PYSQLINSERT_H
