/***************************************************************************
    file	         : tkc_pyvalue.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_PYVALUE_H
#define	__TKC_PYVALUE_H


#include	<qobject.h>
#include	<qshared.h>
#include	<qptrdict.h>

#include	"kb_python.h"


/*  TKCPyType								*/
/*  ---------								*/
/*  Structure used to contain python type-related information for a	*/
/*  particular type.							*/

struct	TKCPyType
{
	enum	TKCPyTypeCode
	{
		Nothing,
		Buffer,
		Cell,
		CFunction,
		Class,
		CObject,
		Code,
		Complex,
		Dict,
		File,
		Float,
		Frame,
		Function,
		Instance,
		Int,
		List,
		Long,
		Method,
		Module,
		Range,
		Slice,
		String,
		Tuple,
		Type,
		Unicode,

		Null,
		Unknown
	}	;

	PyTypeObject	*typeObj	;	/* Python type object	*/
	TKCPyTypeCode	typeCode	;	/* TKC Python type code	*/
	const char	*typeName	;	/* Textual type name	*/
	bool		expandable	;	/* Can be expanded	*/
	bool		simpleVal	;	/* Has simple value	*/
}	;


/*  TKCPyValue								*/
/*  ----------								*/
/*  This class wraps a python object (a value) and provides additional	*/
/*  information about it.						*/

class	TKCPyValue : public QObject, public QShared
{
	Q_OBJECT

	static	QPtrDict<TKCPyValue>	allValues	;

	PyObject	*pvalue	;	/* The value object		*/
	const TKCPyType	*ptype	;	/* Debugger type information	*/

	TKCPyValue	(PyObject *) ;

public	:

       ~TKCPyValue 	()	;

	inline	PyObject	*value	() { return pvalue ; }
	inline	const TKCPyType	*type	() { return ptype  ; }

	static	TKCPyValue	*allocValue (PyObject *) ;
}	;



#endif	// __TKC_PYVALUE_H
