/***************************************************************************
    file	         : tkc_labeller.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qapp.h>
#include	<qpalette.h>

#include	"tkc_labeller.h"


TKCLabeller::TKCLabeller
	(	QWidget		*parent,
		const char	*legend
	)
	:
	QWidget	(parent),
	layout	(this),
	label	(this)
{
	layout.addWidget (&label) ;

	QPalette pal = QApplication::palette () ;
	pal.setColor (QColorGroup::Foreground, 	white   ) ;
	pal.setColor (QColorGroup::Background,	darkBlue) ;

	label.setFixedHeight	(18 ) ;
	label.setPalette	(pal) ;

	setLegend	(legend) ;
}

void	TKCLabeller::setWidget
	(	QWidget		*widget
	)
{
	layout.addWidget (widget) ;
}

void	TKCLabeller::setLegend
	(	const char	*legend
	)
{
	label.setText (QString("  %1").arg(legend)) ;
}

void TKCLabeller::resizeEvent (QResizeEvent *e)
{
QRect g = geometry() ;
QSize m = minimumSize() ;
fprintf (stderr, "resize %s (%d,%d,%d,%d) (%d,%d)\n", 
		 (const char *)label.text(), g.x(), g.y(), g.width(), g.height(),
		m.width(), m.height()) ;
	QWidget::resizeEvent (e) ;
}

