import exceptions
import re


class Warning (StandardError) :

    pass

class Error (StandardError) :

    pass

class InterfaceError (Error) :

    pass

class DatabaseError (Error) :

    pass

class DataError (DatabaseError) :

    pass

class OperationalError (DatabaseError) :

    pass

class IntegrityError (DatabaseError) :

    pass

class InternalError (DatabaseError) :

    pass

class ProgrammingError (DatabaseError) :

    pass

class NotSupportedError (DatabaseError) :

    pass




class RekallCursor :

    def __init__ (self, connection) :
        self.__connection = connection
        self.__cursor = None
        self.__rowno = None
        self.arraysize = 1

    def mkcursor (self, operation) :

        match = re.match ("\s*select\s", operation, re.I) 
        if match :
            #print  "Execute: select"
            return self.__connection.qrySelect (operation)

        match = re.match ("\s*insert\s\s*into\s\s*(\w[a-z0-9_]+)", operation, re.I)
        if match :
            #print  "Execute: insert"
            return self.__connection.qryInsert (operation, match.group(1))

        match = re.match ("\s*update\s\s*(\w[a-z0-9_]+)", operation, re.I)
        if match :
            #print  "Execute: update"
            return self.__connection.qryUpdate (operation, match.group(1))

        match = re.match ("\s*delete\s\s*from\s\s*(\w[a-z0-9_]+)", operation, re.I)
        if match :
            #print  "Execute: delete"
            return self.__connection.qryDelete (operation, match.group(1))

        raise ProgrammingError

    def execute (self, operation, parameters) :

        #print "Execute: ", operation
        #for param in parameters :
        #    print "Param   : ", param

        self.__cursor = self.mkcursor (operation)        
        self.__rowno = 0

        if not self.__cursor.execute (parameters) :
            raise DatabaseError, self.__cursor.lastError()

    def close (self) :
        self.__cursor = None
        self.__rowno = 0 ;

    def rowcount (self) :
        return self.__cursor.getNumRows()

    def rowexists (self, rowno) :
        return self.__cursor.rowExists (rowno)

    def fetchone (self) :
        if not self.rowexists (self.__rowno) :
            return None ;
        res = []
        for colno in range (self.__cursor.getNumFields()) :
            res.append (self.__cursor.getField (self.__rowno, colno))
        self.__rowno = self.__rowno + 1
        return res

    def fetchmany (self, count) :
        if count == None : count = self.arraysize
        res = []
        while count > 0 and self.rowexists (self.__rowno) :
            res.append (self.fetchone())
            count = count - 1
        return res

    def fetchall (self) :
        res = []
        while self.rowexists (self.__rowno) :
            res.append (self.fetchone())
        return res

    def description (self) :
        res = []
        for colno in range (self.__cursor.getNumFields()) :
           res.append ([self._cursor.getFieldName(colno)])
        return res

    def setinputsizes (self) :
      return None

    def setoutputsize (self) :
      return None



class RekallDBI :

    def __init__ (self, object, server) :
        self.__server     = server
        self.__connection = object.getForm().openServer(server)

    def isOpen (self) :
        return self.__connection != None

    def close (self) :
        self.__connection = None

    def commit (self) :
        raise NotSupportedError

    def rollback (self) :
        raise NotSupportedError

    def cursor (self) :
        if not self.isOpen() : return None
        return RekallCursor (self.__connection)



def connect (object, server) :

    dbi = RekallDBI (object, server)
    if not dbi.isOpen() : return None
    return dbi



apilevel     = "2.0"
threadsafety = 0
paramstyle   = 'qmark'



def test (object) :
    con = connect(object, "Orders")
    cur = con.cursor()
    cur.execute("select * from Client", [])
    object.logscript("cursor rows: " + `cur.rowcount()`)
    row = cur.fetchone()
    while row != None :
        line = "Row :"
        for val in row :
            line = line + " " + val
        object.logscript (line)
        row = cur.fetchone()
    

