#!/bin/sh
#
#  rpmlist	- Build file list for RPM package building
#
#  arg1		- App name
#  arg2		- Build root directory
#  arg3		- RPM build directory

APPNAME=$1
   TEMP=/tmp/${APPNAME}.files
   LIST=$3/file.list.${APPNAME}


(
	cd $2
	find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,'
	find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,'
	find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,'
)	\
	> $TEMP

grep '/bin/rekallrt$'     		$TEMP > ${LIST}.full
grep '/bin/rekallrtDemo$' 		$TEMP > ${LIST}.demo
grep '/doc/'				$TEMP > ${LIST}.docs

grep -v -e '/bin/rekallrt$' 	\
	-e '/bin/rekallrtDemo$'	\
	-e '/doc/'			$TEMP | grep -v -e odbc -e db2cli > ${LIST}.libs

( grep odbc   $TEMP || true ) > ${LIST}.odbc
( grep db2cli $TEMP || true ) > ${LIST}.db2cli

