/***************************************************************************
    file	         : kb_myadvanced.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/



#include	"kb_myadvanced.h"

#include	<qtabwidget.h>



/*  KBMyAdvanced							*/
/*  KBMyAdvanced: Constructor for MySQL advanced options object		*/
/*  (returns)	: KBMyAdvanced	:					*/

KBMyAdvanced::KBMyAdvanced  ()
	:
	KBDBAdvanced ("mysql")
{
	fprintf	(stderr, "KBMyAdvanced::KBMyAdvanced  ()\n") ;

	m_ignoreCharset	= false	;
}

/*  KBMyAdvanced							*/
/*  ~KBMyAdvanced: Destructor for MySQL advanced options object		*/
/*  (returns)	 :		:					*/

KBMyAdvanced::~KBMyAdvanced ()
{
}

/*  KBMyAdvanced							*/
/*  load	: Load settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	KBMyAdvanced::load
	(	const QDomElement &driverElem
	)
{
	m_ignoreCharset	= driverElem.attribute ("ignorecharset").toUInt() ;
}

/*  KBMyAdvanced							*/
/*  save	: Save settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	KBMyAdvanced::save
	(	QDomElement	&driverElem
	)
{
	driverElem.setAttribute ("ignorecharset",  m_ignoreCharset) ;
}

/*  KBMyAdvanced							*/
/*  setupDialog	: Set up advanced options dialog			*/
/*  tabWidget	: QTabWidget *	: Tab widget to which to attach pages	*/
/*  (returns)	: void		:					*/

void	KBMyAdvanced::setupDialog
	(	QTabWidget	*tabWidget
	)
{
	fprintf	(stderr, "KBMyAdvanced::setupDialog  ()\n") ;

	QWidget		*advGeneral	= new QWidget	  (tabWidget ) ;
	QVBoxLayout	*layGeneral	= new QVBoxLayout (advGeneral) ;

	tabWidget->addTab (advGeneral, "MySQL") ;

	m_cbIgnoreCharset	= new QCheckBox (advGeneral) ;
	m_cbIgnoreCharset	->setText	(TR("Ignore MySQL character set")) ;
	m_cbIgnoreCharset	->setChecked	(m_ignoreCharset) ;

	m_cbFoundRows		= new QCheckBox (advGeneral) ;
	m_cbFoundRows		->setText	(TR("Return found row count in update")) ;
	m_cbFoundRows		->setChecked	(m_foundRows	) ;

	layGeneral->addWidget (m_cbIgnoreCharset) ;
	layGeneral->addWidget (m_cbFoundRows	) ;
	layGeneral->addStretch() ;
}

/*  KBMyAdvanced							*/
/*  saveDialog	: Save results from dialog				*/
/*  (returns)	: void		:					*/

void	KBMyAdvanced::saveDialog ()
{
	m_ignoreCharset = m_cbIgnoreCharset ->isChecked() ;
	m_foundRows	= m_cbFoundRows	    ->isChecked() ;
}

/*  KBMyAdvanced							*/
/*  copy	: Replicate this object					*/
/*  (returns)	: KBMyAdvanced * : Replicated object			*/

KBDBAdvanced
	*KBMyAdvanced::copy ()
{
	KBMyAdvanced	*copy	= new KBMyAdvanced ()	;

	copy->m_ignoreCharset	= m_ignoreCharset	;
	copy->m_foundRows	= m_foundRows		;

	return	copy	;
}
