/***************************************************************************
    file	         : kb_pgadvanced.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qtabwidget.h>
#include	<qgrid.h>

#ifndef		_WIN32
#include	"kb_pgadvanced.moc"
#else
#include	"kb_pgadvanced.h"
#endif



KBPgGrantsDlg::KBPgGrantsDlg
	(	bool		grantSelect,
		bool		grantInsert,
		bool		grantUpdate,
		bool		grantDelete,
		const QString	&grantTo,
		bool		mapExpressions
	)
	:
	QDialog		(),
	m_cbGrantSelect	(this),
	m_cbGrantInsert	(this),
	m_cbGrantUpdate	(this),
	m_cbGrantDelete	(this),
	m_to		(this),
	m_leGrantTo	(this),
	m_bOK		(this),
	m_bSkip		(this),
	m_bCancel	(this),
	m_mapExpressions(mapExpressions)
{
	setCaption	(TR("Set grants")) ;

	m_cbGrantSelect	.setChecked (grantSelect) ;
	m_cbGrantInsert	.setChecked (grantInsert) ;
	m_cbGrantUpdate	.setChecked (grantUpdate) ;
	m_cbGrantDelete	.setChecked (grantDelete) ;
	m_leGrantTo	.setText    (grantTo)	  ;

	m_cbGrantSelect	.setText    (TR("Grant select")) ;
	m_cbGrantInsert	.setText    (TR("Grant insert")) ;
	m_cbGrantUpdate	.setText    (TR("Grant update")) ;
	m_cbGrantDelete	.setText    (TR("Grant delete")) ;

	m_to		.setText    (TR("To"))	  ;
	m_bOK		.setText    (TR("OK"))	  ;
	m_bSkip		.setText    (TR("Skip"))  ;
	m_bCancel	.setText    (TR("Cancel"));

	QVBoxLayout	*layMain    = new QVBoxLayout (this) ;
	QGridLayout	*layGrants  = new QGridLayout (layMain) ;
	QHBoxLayout	*layButt    = new QHBoxLayout (layMain) ;

	layGrants->addMultiCellWidget (&m_cbGrantSelect, 0, 0, 0, 1) ;
	layGrants->addMultiCellWidget (&m_cbGrantInsert, 1, 1, 0, 1) ;
	layGrants->addMultiCellWidget (&m_cbGrantUpdate, 2, 2, 0, 1) ;
	layGrants->addMultiCellWidget (&m_cbGrantDelete, 3, 3, 0, 1) ;
	layGrants->addMultiCellWidget (&m_to	,	 4, 4, 0, 0) ;
	layGrants->addMultiCellWidget (&m_leGrantTo,	 4, 4, 1, 1) ;
	layGrants->setRowStretch      (5, 1) ;

	layButt  ->addStretch	      () ;
	layButt  ->addWidget	      (&m_bOK	 ) ;
	layButt  ->addWidget	      (&m_bSkip  ) ;
	layButt  ->addWidget	      (&m_bCancel) ;

	connect	(&m_bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(&m_bSkip,   SIGNAL(clicked()), SLOT(clickSkip  ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;
}

void	KBPgGrantsDlg::clickOK ()
{
	if (
		!m_cbGrantSelect.isChecked() &&
		!m_cbGrantInsert.isChecked() &&
		!m_cbGrantUpdate.isChecked() &&
		!m_cbGrantDelete.isChecked()
	   )
	{
		KBError::EWarning
		(	TR("At least one grant must be given"),
			QString::null,
			__ERRLOCN
		)	;
		return	;
	}

	if (m_leGrantTo.text().isEmpty())
	{
		KBError::EWarning
		(	TR("Please specify to whom to grant"),
			QString::null,
			__ERRLOCN
		)	;
		return	;
	}

	done	(2) ;
}

void	KBPgGrantsDlg::clickSkip ()
{
	done	(1) ;
}

void	KBPgGrantsDlg::clickCancel ()
{
	done	(0) ;
}

QString	KBPgGrantsDlg::grantText ()
{
	QString	text	= "grant " ;
	cchar	*sep	= ""	   ;

	if (m_cbGrantSelect.isChecked())
	{	text	+= sep		;
		text	+= "select"	;
		sep	 = ", "		;
	}
	if (m_cbGrantInsert.isChecked())
	{	text	+= sep		;
		text	+= "insert"	;
		sep	 = ", "		;
	}
	if (m_cbGrantUpdate.isChecked())
	{	text	+= sep		;
		text	+= "update"	;
		sep	 = ", "		;
	}
	if (m_cbGrantDelete.isChecked())
	{	text	+= sep		;
		text	+= "delete"	;
		sep	 = ", "		;
	}

	text	+= m_mapExpressions ? " on \"%1\" to " : " on %1 to " ;
	text	+= m_leGrantTo.text() ;
	return	text ;
}

/*  ------------------------------------------------------------------  */

/*  KBPgAdvanced							*/
/*  KBPgAdvanced: Constructor for PgSQL advanced options object		*/
/*  (returns)	: KBPgAdvanced	:					*/

KBPgAdvanced::KBPgAdvanced  ()
	:
	KBDBAdvanced ("pgsql")
{
	fprintf	(stderr, "KBPgAdvanced::KBPgAdvanced  ()\n") ;

	m_primaryIsSerial	= false	;
	m_ignoreUser		= false ;
	m_showPgSQLObjects	= false ;
	m_logInternal		= false ;
	m_requireSSL		= false ;
	m_caseInsensitive	= false ;
	m_mapExpressions 	= false ;
	m_useTimeouts		= false ;
	m_stmtTimeout		= -1	;
	m_lockTimeout		= -1	;

	m_grants		= false	;
	m_grantSelect		= false	;
	m_grantInsert		= false	;
	m_grantUpdate		= false	;
	m_grantDelete		= false	;
	m_grantTo		= ""	;
	m_grantPopup		= false	;
}

/*  KBPgAdvanced							*/
/*  ~KBPgAdvanced: Destructor for PgSQL advanced options object		*/
/*  (returns)	 :		:					*/

KBPgAdvanced::~KBPgAdvanced ()
{
}

/*  KBPgAdvanced							*/
/*  load	: Load settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	KBPgAdvanced::load
	(	const QDomElement &driverElem
	)
{
	m_primaryIsSerial = driverElem.attribute ("primaryisserial" ).toUInt() ;
	m_ignoreUser	  = driverElem.attribute ("ignoreuser"      ).toUInt() ;
	m_showPgSQLObjects= driverElem.attribute ("showpgsqlobjects").toUInt() ;
	m_logInternal	  = driverElem.attribute ("loginternal"	    ).toUInt() ;
	m_requireSSL	  = driverElem.attribute ("requiressl"	    ).toUInt() ;
	m_caseInsensitive = driverElem.attribute ("caseinsensitive" ).toUInt() ;
	m_mapExpressions  = driverElem.attribute ("mapexpressions"  ).toUInt() ;
	m_useTimeouts	  = driverElem.attribute ("usetimeouts"     ).toUInt() ;
	m_stmtTimeout 	  = driverElem.attribute ("stmttimeout"	    ).toInt () ;
	m_lockTimeout 	  = driverElem.attribute ("locktimeout"	    ).toInt () ;

	m_grants	  = driverElem.attribute ("grants"	    ).toUInt() ;
	m_grantSelect	  = driverElem.attribute ("grantselect"     ).toUInt() ;
	m_grantInsert	  = driverElem.attribute ("grantinsert"     ).toUInt() ;
	m_grantUpdate	  = driverElem.attribute ("grantupdate"     ).toUInt() ;
	m_grantDelete	  = driverElem.attribute ("grantdelete"     ).toUInt() ;
	m_grantTo	  = driverElem.attribute ("grantto"	    )	       ;
	m_grantPopup	  = driverElem.attribute ("grantpopup"      ).toUInt() ;
}

/*  KBPgAdvanced							*/
/*  save	: Save settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	KBPgAdvanced::save
	(	QDomElement	&driverElem
	)
{
	driverElem.setAttribute ("primaryisserial",  m_primaryIsSerial	) ;
	driverElem.setAttribute ("ignoreuser",       m_ignoreUser	) ;
	driverElem.setAttribute ("showpgsqlobjects", m_showPgSQLObjects	) ;
	driverElem.setAttribute ("loginternal",      m_logInternal	) ;
	driverElem.setAttribute ("requiressl",       m_requireSSL	) ;
	driverElem.setAttribute ("caseinsensitive",  m_caseInsensitive	) ;
	driverElem.setAttribute ("mapexpressions",   m_mapExpressions   ) ;
	driverElem.setAttribute ("usetimeouts",      m_useTimeouts	) ;
	driverElem.setAttribute ("stmttimeout",      m_stmtTimeout	) ;
	driverElem.setAttribute ("locktimeout",      m_lockTimeout	) ;

	driverElem.setAttribute ("grants",	     m_grants		) ;
	driverElem.setAttribute ("grantselect",      m_grantSelect	) ;
	driverElem.setAttribute ("grantinsert",      m_grantInsert	) ;
	driverElem.setAttribute ("grantupdate",      m_grantUpdate	) ;
	driverElem.setAttribute ("grantdelete",      m_grantDelete	) ;
	driverElem.setAttribute ("grantto",	     m_grantTo		) ;
	driverElem.setAttribute ("grantpopup",       m_grantPopup	) ;
}

/*  KBPgAdvanced							*/
/*  setupDialog	: Set up advanced options dialog			*/
/*  tabWidget	: QTabWidget *	: Tab widget to which to attach pages	*/
/*  (returns)	: void		:					*/

void	KBPgAdvanced::setupDialog
	(	QTabWidget	*tabWidget
	)
{
	fprintf	(stderr, "KBPgAdvanced::setupDialog  ()\n") ;

	QWidget		*advGeneral	= new QWidget	  (tabWidget ) ;
	QWidget		*advGrants	= new QWidget	  (tabWidget ) ;
	QVBoxLayout	*layGeneral	= new QVBoxLayout (advGeneral) ;
	QGridLayout	*layGrants	= new QGridLayout (advGrants ) ;

	tabWidget->addTab (advGeneral, "PostgreSQL") ;
	tabWidget->addTab (advGrants,  "Grants"    ) ;

	m_cbPrimaryIsSerial	= new QCheckBox (advGeneral) ;
	m_cbPrimaryIsSerial	->setText 	(TR("Use serial type for primary key")) ;
	m_cbPrimaryIsSerial	->setChecked (m_primaryIsSerial ) ;

	m_cbIgnoreUser		= new QCheckBox (advGeneral) ;
	m_cbIgnoreUser	    	->setText 	(TR("Show tables irrespective of user")) ;
	m_cbIgnoreUser	    	->setChecked (m_ignoreUser      ) ;

	m_cbShowPgSQLObjects	= new QCheckBox (advGeneral) ;
	m_cbShowPgSQLObjects	->setText 	(TR("Show PostgreSQL objects")) ;
	m_cbShowPgSQLObjects	->setChecked (m_showPgSQLObjects) ;

	m_cbLogInternal		= new QCheckBox (advGeneral) ;
	m_cbLogInternal     	->setText 	(TR("Log internal driver queries")) ;
	m_cbLogInternal     	->setChecked (m_logInternal) ;

	m_cbRequireSSL		= new QCheckBox (advGeneral) ;
	m_cbRequireSSL      	->setText 	(TR("Requires SSL connection")) ;
	m_cbRequireSSL      	->setChecked (m_requireSSL) ;

	m_cbCaseInsensitive	= new QCheckBox (advGeneral) ;
	m_cbCaseInsensitive    	->setText 	(TR("Case-insensitive like")) ;
	m_cbCaseInsensitive    	->setChecked (m_caseInsensitive) ;

	m_cbMapExpressions	= new QCheckBox (advGeneral) ;
	m_cbMapExpressions	->setText 	(TR("Wrap names with \"...\"")) ;
	m_cbMapExpressions	->setChecked	(m_mapExpressions) ;

	m_cbUseTimeouts		= new QCheckBox (advGeneral) ;
	m_cbUseTimeouts		->setText 	(TR("Use statement timeouts")) ;
	m_cbUseTimeouts		->setChecked	(m_useTimeouts) ;

	QGrid	*t = new QGrid (2, advGeneral) ;

	new QLabel (TR("Statement timeout"), t) ;
	m_spStmtTimeout	= new QSpinBox	(t) ;
	m_spStmtTimeout	->setRange	(0, 0x7fffffff) ;
	m_spStmtTimeout	->setValue	(m_stmtTimeout >= 0 ? m_stmtTimeout : 0) ;
	m_spStmtTimeout	->setFixedWidth (m_spStmtTimeout->sizeHint().width()) ;

	new QLabel (TR("Lock for update timeout"), t) ;
	m_spLockTimeout	= new QSpinBox	(t) ;
	m_spLockTimeout	->setRange	(0, 0x7fffffff) ;
	m_spLockTimeout	->setValue	(m_lockTimeout >= 0 ? m_lockTimeout : 0) ;
	m_spLockTimeout	->setFixedWidth (m_spLockTimeout->sizeHint().width()) ;

	layGeneral->addWidget (m_cbPrimaryIsSerial ) ;
	layGeneral->addWidget (m_cbIgnoreUser      ) ;
	layGeneral->addWidget (m_cbShowPgSQLObjects) ;
	layGeneral->addWidget (m_cbLogInternal	   ) ;
	layGeneral->addWidget (m_cbRequireSSL	   ) ;
	layGeneral->addWidget (m_cbCaseInsensitive ) ;
	layGeneral->addWidget (m_cbMapExpressions  ) ;
	layGeneral->addWidget (m_cbUseTimeouts	   ) ;

	layGeneral->addWidget (t) ;
	layGeneral->addStretch( ) ;

	m_cbGrants		= new QCheckBox (advGrants) ;
	m_cbGrants		->setText	(TR("Set grants on table")) ;
	m_cbGrants		->setChecked	(m_grants) ;

	m_cbGrantSelect		= new QCheckBox (advGrants) ;
	m_cbGrantSelect		->setText	(TR("Grant select")) ;
	m_cbGrantSelect		->setChecked	(m_grantSelect) ;

	m_cbGrantInsert		= new QCheckBox (advGrants) ;
	m_cbGrantInsert		->setText	(TR("Grant insert")) ;
	m_cbGrantInsert		->setChecked	(m_grantInsert) ;

	m_cbGrantUpdate		= new QCheckBox (advGrants) ;
	m_cbGrantUpdate		->setText	(TR("Grant update")) ;
	m_cbGrantUpdate		->setChecked	(m_grantUpdate) ;

	m_cbGrantDelete		= new QCheckBox (advGrants) ;
	m_cbGrantDelete		->setText	(TR("Grant delete")) ;
	m_cbGrantDelete		->setChecked	(m_grantDelete) ;

	QLabel *lGrantTo	= new QLabel	(advGrants) ;
	lGrantTo		->setText	(TR("Grant to")) ;

	m_leGrantTo		= new QLineEdit (advGrants) ;
	m_leGrantTo		->setText	(m_grantTo) ;

	m_cbGrantPopup		= new QCheckBox (advGrants) ;
	m_cbGrantPopup		->setText	(TR("Show pop-up on creation")) ;
	m_cbGrantPopup		->setChecked	(m_grantPopup) ;

	layGrants->addMultiCellWidget (m_cbGrants,	0, 0, 0, 1) ;
	layGrants->addMultiCellWidget (m_cbGrantSelect,	1, 1, 0, 1) ;
	layGrants->addMultiCellWidget (m_cbGrantInsert,	2, 2, 0, 1) ;
	layGrants->addMultiCellWidget (m_cbGrantUpdate,	3, 3, 0, 1) ;
	layGrants->addMultiCellWidget (m_cbGrantDelete,	4, 4, 0, 1) ;
	layGrants->addMultiCellWidget (lGrantTo,	5, 5, 0, 0) ;
	layGrants->addMultiCellWidget (m_leGrantTo,	5, 5, 1, 1) ;
	layGrants->addMultiCellWidget (m_cbGrantPopup,	6, 6, 0, 1) ;
	layGrants->setRowStretch      (7, 1) ;

	slotGrantsChanged	() ;
	slotUseTimeoutChanged	() ;

	connect
	(	m_cbGrants,
		SIGNAL	(toggled(bool)),
		SLOT	(slotGrantsChanged())
	)	;
	connect
	(	m_cbUseTimeouts,
		SIGNAL	(toggled(bool)),
		SLOT	(slotUseTimeoutChanged())
	)	;
}

void	KBPgAdvanced::slotGrantsChanged ()
{
	bool	on	= m_cbGrants->isChecked () ;

	m_cbGrantSelect	->setEnabled (on) ;
	m_cbGrantInsert	->setEnabled (on) ;
	m_cbGrantUpdate	->setEnabled (on) ;
	m_cbGrantDelete	->setEnabled (on) ;
	m_leGrantTo	->setEnabled (on) ;
	m_cbGrantPopup	->setEnabled (on) ;
}

void	KBPgAdvanced::slotUseTimeoutChanged ()
{
	m_spStmtTimeout->setEnabled (m_cbUseTimeouts->isChecked()) ;
	m_spLockTimeout->setEnabled (m_cbUseTimeouts->isChecked()) ;
}



/*  KBPgAdvanced							*/
/*  saveDialog	: Save results from dialog				*/
/*  (returns)	: void		:					*/

void	KBPgAdvanced::saveDialog ()
{
	m_primaryIsSerial  = m_cbPrimaryIsSerial ->isChecked() ;
	m_ignoreUser       = m_cbIgnoreUser      ->isChecked() ;
	m_showPgSQLObjects = m_cbShowPgSQLObjects->isChecked() ;
	m_logInternal	   = m_cbLogInternal	 ->isChecked() ;
	m_requireSSL	   = m_cbRequireSSL	 ->isChecked() ;
	m_caseInsensitive  = m_cbCaseInsensitive ->isChecked() ;
	m_mapExpressions   = m_cbMapExpressions  ->isChecked() ;
	m_useTimeouts	   = m_cbUseTimeouts	 ->isChecked() ;
	m_stmtTimeout      = m_spStmtTimeout	 ->value    () ;
	m_lockTimeout      = m_spLockTimeout	 ->value    () ;

	m_grants	   = m_cbGrants		 ->isChecked() ;
	m_grantSelect	   = m_cbGrantSelect	 ->isChecked() ;
	m_grantInsert	   = m_cbGrantInsert	 ->isChecked() ;
	m_grantUpdate	   = m_cbGrantUpdate	 ->isChecked() ;
	m_grantDelete	   = m_cbGrantDelete	 ->isChecked() ;
	m_grantTo	   = m_leGrantTo	 ->text	    () ;
	m_grantPopup	   = m_cbGrantPopup	 ->isChecked() ;
}

/*  KBPgAdvanced							*/
/*  copy	: Replicate this object					*/
/*  (returns)	: KBPgAdvanced * : Replicated object			*/

KBDBAdvanced
	*KBPgAdvanced::copy ()
{
	KBPgAdvanced	*copy	= new KBPgAdvanced ()	;

	copy->m_primaryIsSerial = m_primaryIsSerial	;
	copy->m_ignoreUser      = m_ignoreUser		;
	copy->m_showPgSQLObjects= m_showPgSQLObjects	;
	copy->m_logInternal	= m_logInternal		;
	copy->m_requireSSL	= m_requireSSL		;
	copy->m_caseInsensitive	= m_caseInsensitive	;
	copy->m_mapExpressions	= m_mapExpressions 	;
	copy->m_useTimeouts	= m_useTimeouts 	;
	copy->m_stmtTimeout	= m_stmtTimeout 	;
	copy->m_lockTimeout	= m_lockTimeout 	;

	copy->m_grants		= m_grants		;
	copy->m_grantSelect	= m_grantSelect		;
	copy->m_grantInsert	= m_grantInsert		;
	copy->m_grantUpdate	= m_grantUpdate		;
	copy->m_grantDelete	= m_grantDelete		;
	copy->m_grantTo		= m_grantTo		;
	copy->m_grantPopup	= m_grantPopup		;

	return	copy	;
}
