/***************************************************************************
    file	         : kb_callback.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qguardedptr.h>
#include	<qwidget.h>
#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_attrdict.h"
#include	"kb_callback.h"
#include	"kb_viewer.h"
#include	"kb_textlog.h"
#include	"kb_querylog.h"
#include	"kb_eventlog.h"
#include	"kb_dbaseviewer.h"
#include	"kb_director.h"
#include	"kb_appptr.h"
#include	"kb_errordlg.h"
#include	"kbase.h"


class		KBasePart	;

class	KBaseCallback : public KBCallback
{
public	:

	virtual	KB::ShowRC	openObject 	(KBLocation &, KB::ShowAs, QDict<QString> &, KBError &, const KBValue &, QDict<QString> *) ;
	virtual	bool		newObject  	(KBLocation &, KBError &) ;
	virtual	bool		editScript 	(KBLocation &, const QString  &, const QString &, uint, KBError &) ;
	virtual	KBObjBase	*showingObj	(KBLocation &) ;
	virtual	KBNode		*objectNode	(KBLocation &) ;

	virtual	void		logQuery	(const QString &, const QString &, bool, uint, const KBValue *) ;
	virtual	void		*logEvent	(const QString &, const QString &, const QString &, const QString &, uint, const KBValue *) ;
	virtual	void    	logEventResult	(const KBValue &, bool, void *) ;
	virtual	void		logScript	(const QString &, bool) ;

	virtual	TKAction	*globalAction	(const QString &) ;
	virtual	bool		useMDIMode	() ;

	virtual	void		addPart		(KBasePart *) ;
	virtual	void		dropPart	(KBasePart *) ;
	virtual	void		alterPart	(KBasePart *) ;

	virtual	bool		displayError	(const KBError &, const QString &, cchar *, uint) ;
}	;


extern	KBDirector	director	;


KB::ShowRC
	KBaseCallback::openObject
	(	KBLocation	&location,
		KB::ShowAs	showAs,
		QDict<QString>	&pDict,
		KBError		&pError,
		const KBValue	&key,
		QDict<QString>	*rDict
	)
{
	KBaseApp *app = KBDBaseViewer::findKBaseApp (location) ;
	return	app->openObject (location, showAs, pDict, pError, key, rDict) ;
}

bool	KBaseCallback::newObject
	(	KBLocation	&location,
		KBError		&pError
	)
{
	KBaseApp *app = KBDBaseViewer::findKBaseApp (location) ;
	return	app->newObject  (location, pError) ;
}

bool	KBaseCallback::editScript
	(	KBLocation	&location,
		const QString	&eText,
		const QString	&ePatt,
		uint		lno,
		KBError		&pError
	)
{
	KBAttrDict	pDict	;
	pDict.addValue	("errText", eText) ;
	pDict.addValue	("errPat",  ePatt) ;
	pDict.addValue	("lno",     lno  ) ;
	return	openObject (location, KB::ShowAsData, pDict, pError, KBValue(), 0) ;
}

KBObjBase
	*KBaseCallback::showingObj
	(	KBLocation	&location
	)
{
	KBaseApp *app = KBDBaseViewer::findKBaseApp (location) ;
	return	app->showingObj (location) ;
}


KBNode	*KBaseCallback::objectNode
	(	KBLocation	&location
	)
{
	KBaseApp *app = KBDBaseViewer::findKBaseApp (location) ;
	return	app->objectNode (location) ;
}

void	KBaseCallback::logQuery
	(	const QString	&server,
		const QString	&text,
		bool		rc,
		uint		argc,
		const KBValue	*argv	
	)
{
	extern	QGuardedPtr<KBQueryLog> queryLog ;
	if (queryLog ) queryLog->logQuery (server, text, rc, argc, argv) ;
}

void	*KBaseCallback::logEvent
	(	const QString	&type,
		const QString	&objName,
		const QString	&objType,
		const QString	&eventName,
		uint		argc,
		const KBValue	*argv	
	)
{
	extern	QGuardedPtr<KBEventLog> eventLog ;
	if (!eventLog) return 0 ;
	return	eventLog->logEvent (type, objName, objType, eventName, argc, argv) ;
}

void	KBaseCallback::logEventResult
	(	const KBValue	&resval,
		bool		ok,
		void		*logid
	)
{
	extern	QGuardedPtr<KBEventLog> eventLog ;
	if (eventLog)
		eventLog->logEventResult (resval, ok, logid) ;
}

void	KBaseCallback::logScript
	(	const QString	&text,
		bool		rc
	)
{
	extern	QGuardedPtr<KBTextLog> scriptLog ;
	if (scriptLog) scriptLog->logText (text, rc) ;
}

TKAction*KBaseCallback::globalAction
	(	const QString	&name
	)
{
	extern	QDict<TKAction>	globalActions	;
	return	globalActions.find (name)	;
}

bool	KBaseCallback::useMDIMode ()
{
	extern	bool useMDI ;
	return	useMDI	    ;
}



void	KBaseCallback::addPart
	(	KBasePart	*part
	)
{
	director.addPart (part) ;
}

void	KBaseCallback::dropPart
	(	KBasePart	*part
	)
{
	director.dropPart (part) ;
}

void	KBaseCallback::alterPart
	(	KBasePart	*part
	)
{
	director.alterPart (part) ;
}


bool	KBaseCallback::displayError
	(	const KBError	&pError,
		const QString	&caption,
		cchar		*dfile,
		uint		dlno
	)
{
	KBErrorDlg eDlg
		   (	pError.getEType  (),
			pError.getMessage(),
			pError.getDetails(),
			caption,
			pError.getFile   (),
			pError.getLineno (),
			dfile,
			dlno
		   )	;
	eDlg.exec  ()	;

	return	true	;
}


void	setCallBack ()
{
	KBAppPtr::setCallback  (new KBaseCallback ()) ;
}

