/***************************************************************************
    file	         : kb_listwidget.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>
#include	<qlabel.h>
#include	<qheader.h>

#include	"kb_classes.h"

#ifndef		_WIN32
#include	"kb_listwidget.moc"
#else
#include	"kb_listwidget.h"
#endif


/*  KBListWidget							*/
/*  KBListWidget: Constructor for list-based tab widget replacement	*/
/*  parent	: QWidget *	: Parent widget				*/
/*  (returns)	: KBListWidget	:					*/

KBListWidget::KBListWidget
	(	QWidget		*parent
	)
	:
	QWidget		(parent),
	m_list		(this),
	m_stack		(this)
{
	QHBoxLayout	*main	= new QHBoxLayout (this) ;

	main->addWidget (&m_list ) ;
	main->addWidget (&m_stack, 1) ;

	m_list.addColumn	(TR("Objects")) ;
	m_list.setSorting	(-1) ;
	m_list.setHScrollBarMode(QScrollView::AlwaysOff) ;
	m_list.setBackgroundMode(PaletteButton) ;
	setBackgroundMode	(PaletteButton) ;

	connect
	(	&m_list,
		SIGNAL(clicked	     (QListViewItem *)),
		SLOT  (slotChangePage(QListViewItem *))
	)	;
	connect
	(	&m_list,
		SIGNAL(returnPressed (QListViewItem *)),
		SLOT  (slotChangePage(QListViewItem *))
	)	;

	m_last	= 0 ;
}

/*  KBListWidget							*/
/*  addPage	: Add a page to the widget				*/
/*  page	: QWidget *	  : Page to add				*/
/*  label	: const QString & : Text for pseudo-tab			*/
/*  icon	: const QPixmap & : Icon for pseudo-tab			*/
/*  (returns)	: void		  :					*/

void	KBListWidget::addPage
	(	QWidget		*page,
		const QString	&label,
		const QPixmap	&icon
	)
{
	m_stack.addWidget (page, m_list.childCount()) ;
	if (m_last == 0) m_stack.raiseWidget(page) ;

	m_last = new QListViewItem
			(	&m_list,
				m_last,
				label,
				QString::number(m_list.childCount())
			)	;

	m_last->setPixmap (0, icon) ;

	m_list.setFixedWidth (m_list.sizeHint().width()) ;
}

/*  KBListWidget							*/
/*  slotChangePage							*/
/*		: User changes page					*/
/*  item	: QListViewItem * : Corresponding item			*/
/*  (returns)	: void		  :					*/

void	KBListWidget::slotChangePage
	(	QListViewItem	*item
	)
{
	if (item != 0)
	{
		m_stack.raiseWidget (item->text(1).toInt  ()) ;
		emit currentChanged (m_stack.visibleWidget()) ;
	}
}

void	KBListWidget::resizeEvent
	(	QResizeEvent	*e
	)
{
	QWidget::resizeEvent  (e) ;
	m_list.setColumnWidth (0, m_list.width() - 2) ;
}
