/***************************************************************************
    file				 : kb_main.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
						   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>

#if		__KB_EMBEDDED
#include	<qpe/qpeapplication.h>
#include	"tkstyle.h"
#else
#include	<qapplication.h>
#endif
#include	<qglobal.h>
#include	<qfileinfo.h>
#include	<qlibrary.h>

#ifdef		_WIN32
#include	<winsock2.h>
#endif

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_splash.h"
#include	"kb_optionsdlg.h"
#include	"kbase.h"


#include	"md5.h"


#if		__KB_TKC
#include	<qsettings.h>
#endif

#if		__KB_EMBEDDED

#if		__KB_RUNTIME
#define		APPNAME		"tkcRekallrt"
#define		APPTITLE	"tkcRekallRT"
#else
#define		APPNAME		"tkcRekall"
#define		APPTITLE	"tkcRekall"
#endif

#else		// __KB_EMBEDDED

#if		__KB_RUNTIME
#define		APPNAME		"rekallrt"
#define		APPTITLE	"RekallRT"
#else
#define		APPNAME		"rekall"
#define		APPTITLE	"Rekall"
#endif

#endif		// __KB_EMBEDDED

#if		__KB_KDE
#include	<kapp.h>
#include	<klocale.h>
#include	<kaboutdata.h>
#include	<kcmdlineargs.h>

static	const	KCmdLineOptions	options[] =
{
	{	"useMDI",		I18N_NOOP("Run in MDI mode"		),	0	},
	{	"useSDI",		I18N_NOOP("Run in SDI mode"		),	0	},
	{	"skipNoteDB",		I18N_NOOP("Don't remember last database"),	0	},
	{	"skipLastDB",		I18N_NOOP("Don't open last database"	),	0	},
	{	"errLocn",		I18N_NOOP("Show error locations"	),	0	},
	{	"errTrace",		I18N_NOOP("Trace errors"		),	0	},
	{	"skipSplash",		I18N_NOOP("Don't show the splash screen"),	0	},
	{	"debug <lang>",		I18N_NOOP("Load language debugger"	),	0	},
	{	"language <lang>",	I18N_NOOP("Set KLocale language"	),	0	},
	{	"+[database]",		I18N_NOOP("Database file"		),	0	},
	{	0,		0,							0	}
}	;

#endif	// __KB_KDE

extern	KBaseApp*kbaseApp	;
extern	bool	__useMDI	;
extern	bool	__useSDI	;
extern	bool	__noNoteDB	;
extern	bool	__noLastDB	;
extern	QString	__initDEB	;
static	bool	__noSplash	;
static	QString	__language	;

#ifdef	_WIN32
static	bool	__console	;
#endif

#if	__KB_EMBEDDED
QPEApplication	*qpeApp		;
#endif

extern	void	setRootDir	(const QString& _rootdir) ;

static	void	myMsgHandler
	(	QtMsgType	type,
		cchar		*msg
	)
{
	switch (type)
	{
		case QtDebugMsg   :
			fprintf	(stderr, "Debug: %s\n",   msg) ;
			break	;

		case QtWarningMsg :
			fprintf	(stderr, "Warning: %s\n", msg) ;
			break	;

		case QtFatalMsg	  :
			fprintf	(stderr, "Fatal: %s\n",   msg) ;
			abort	() ;
			break	;

		default	:
			fprintf	(stderr, "Unknown: %s\n", msg) ;
			abort	() ;
			break	;
	}
}

typedef	int	AUTH	(char [128], auth_byte_t [16]) ;

static	uchar	auth_bytes[] =
{	0xef,	0x1b,	0x06,	0x4b,	0x64,	0x18,	0x40,	0x14,
	0x76,	0x5a,	0x0a,	0x7b,	0x47,	0x0d,	0x42,	0x2f,
	0x69,	0x5f,	0x6e,	0x2e,	0x71,	0x3c,	0x59,	0x2b,
	0x36,	0x43,	0x0c,	0x28,	0x35,	0x49,	0x0e,	0x41,
	0x31,	0x15,	0x2a,	0x12,	0x2c,	0x1c,	0x1a,	0x48,
	0x54,	0x07,	0x66,	0x3d,	0x5e,	0x09,	0x13,	0x3a,
	0x22,	0x52,	0x72,	0x6d,	0x04,	0x1f,	0x1e,	0x6c,
	0x6a,	0x44,	0x55,	0x7a,	0x4a,	0x32,	0x10,	0x56,
	0x19,	0x3f,	0x3e,	0x4c,	0x4f,	0x08,	0x03,	0x27,
	0x63,	0x25,	0x46,	0x33,	0x74,	0x29,	0x53,	0x0f,
	0x68,	0x5d,	0x5c,	0x4e,	0x20,	0x73,	0x45,	0x01,
	0x34,	0x75,	0x1d,	0x21,	0x26,	0x7e,	0x6f,	0x16,
	0x6b,	0x11,	0x5b,	0x17,	0x50,	0x24,	0x67,	0x3b,
	0x70,	0x58,	0x37,	0x60,	0x23,	0x78,	0x57,	0x38,
	0x02,	0x7d,	0x62,	0x77,	0x79,	0x05,	0x0b,	0x39,
	0x7c,	0x4d,	0x30,	0x65,	0x61,	0x51,	0x2d,	0x7f
}	;

static	uchar	auth_order[] =
{	0x00,	0x65,	0x6d,	0x51,	0x6a,	0x24,	0x3b,	0x5b,
	0x59,	0x1e,	0x0a,	0x66,	0x77,	0x0d,	0x5d,	0x45,
	0x27,	0x37,	0x2a,	0x11,	0x08,	0x39,	0x4e,	0x52,
	0x3c,	0x5e,	0x7a,	0x23,	0x14,	0x26,	0x49,	0x15,
	0x62,	0x78,	0x3e,	0x16,	0x64,	0x4c,	0x72,	0x3a,
	0x09,	0x71,	0x22,	0x2c,	0x28,	0x3f,	0x63,	0x4d,
	0x68,	0x53,	0x17,	0x43,	0x4f,	0x7d,	0x79,	0x2b,
	0x0c,	0x21,	0x56,	0x41,	0x48,	0x1d,	0x30,	0x02,
	0x55,	0x35,	0x50,	0x7f,	0x7b,	0x46,	0x0e,	0x2f,
	0x67,	0x76,	0x75,	0x33,	0x07,	0x38,	0x42,	0x12,
	0x3d,	0x04,	0x54,	0x44,	0x60,	0x31,	0x47,	0x6c,
	0x6e,	0x2d,	0x40,	0x19,	0x32,	0x1a,	0x10,	0x1b,
	0x1c,	0x73,	0x29,	0x0f,	0x74,	0x5c,	0x7e,	0x05,
	0x61,	0x5a,	0x6b,	0x20,	0x4a,	0x0b,	0x25,	0x57,
	0x4b,	0x7c,	0x58,	0x70,	0x2e,	0x69,	0x13,	0x5f,
	0x18,	0x1f,	0x6f,	0x01,	0x06,	0x36,	0x34,	0x03
}	;

static	void	auth_append
	(	char		challenge[128]
	)
{
	uint	cp = strlen(challenge) ;

	for (uint idx = 0 ; idx < 128 ; idx += 2)
		challenge[cp++] = auth_bytes[auth_order[idx]] ;

	challenge[cp] = 0 ;

}

static	void	authLoc
	(	char		challenge[128],
		auth_byte_t	digest   [ 16]
	)
{
	auth_state_t 	state	  ;

	auth_append	(challenge) ;
	auth_init	(&state)    ;
	auth_append	(&state, (const auth_byte_t *)challenge, strlen(challenge)) ;
	auth_finish	(&state, digest) ;
}


/*  HACK ALERT:								*/
/*									*/
/*  Under QTopia, applications have a specified main widget; if the	*/
/*  user switches to another application and back then the main widget	*/
/*  appears, irrespective of the original top-level widget. This is not	*/
/*  what is wanted for tkcRekall; we want to maintain the original top-	*/
/*  level widget.							*/
/*									*/
/*  So, we need to call QPEApplication::showMainWidget each time that	*/
/*  the user changes it (opens a form, etc). The best way to maintain	*/
/*  it would be to pick up WindowActivated events, but these seem to go	*/
/*  missing. We therefore do it my steam, catching all cases that can	*/
/*  affect the visible widget, and passing control to the following two	*/
/*  routines.								*/


static	QList<QWidget>		windowList	;

/*  setActiveWindow							*/
/*		: Make a specifed widget the active one			*/
/*  widget	: QWidget *	: Widget in question			*/
/*  (returns)	: void		:					*/

void	setActiveWindow
	(	QWidget		*widget
	)
{
#if	__KB_EMBEDDED
	if (widget != 0)
	{
		/* Move the widget to the head of the window list and	*/
		/* set it as the active one.				*/
		fprintf
		(	stderr,
			"setActiveWindow: [%p]\n",
			(void *)widget
		)	;

		windowList.removeRef	(widget) ;
		windowList.prepend	(widget) ;
		qpeApp->showMainWidget	(widget) ;
	}
#endif
}

/*  dropActiveWindow							*/
/*		: Drop the currently active window if it closes		*/
/*  widget	: QWidget *	: Widget in question			*/
/*  (returns)	: void		:					*/

void	dropActiveWindow
	(	QWidget		*widget
	)
{
#if	__KB_EMBEDDED

	fprintf
	(	stderr,
		"dropActiveWindow: w=%p a=%p\n",
		(void *)widget,
		(void *)windowList.at(0)
	)	;

	/* First case is just a paranoia check in case we get called	*/
	/* with a null widget pointer.					*/
	if (widget == 0)
	{
		return	;
	}

	/* If the widget is not at the head of the window list then	*/
	/* simply remove it from the list (if indeed it is even there).	*/
	if (widget != windowList.at(0))
	{
		windowList.removeRef (widget) ;
		return ;
	}

	windowList.removeRef (widget) ;

	/* OK, widget is the currently active one. We need to find the	*/
	/* next one down the list. The one now at the head should do,	*/
	/* but we are being paranoid here and we check on the top-level	*/
	/* window list.							*/
	QWidgetList   *tlw = QApplication::topLevelWidgets() ;

	if (tlw != 0)
		while (windowList.count() > 0)
		{
			QWidget	*head = windowList.at(0) ;

			if (tlw->findRef (head) < 0)
			{
				fprintf
				(	stderr,
					"dropActiveWindow: lost [%p], removing ...\n",
					(void *)head
				)	;
				windowList.removeFirst () ;
				continue ;
			}

			/* OK, the head widget is a top-level widget,	*/
			/* use this one.				*/
			head->show		()	;
			head->raise		()	;
			head->setActiveWindow	()	;
			setActiveWindow    	(head)	;
			return	;
		}

	/* Final fall back case, use the main application window.	*/
	if (kbaseApp != 0)
	{
		kbaseApp->show		  () ;
		kbaseApp->raise		  () ;
		kbaseApp->setActiveWindow () ;
		setActiveWindow    	  (kbaseApp) ;
	}
#endif
}

static	int	rekall
	(	int	argc,
		char	*argv[],
		AUTH	*authGbl
	)
{
	qInstallMsgHandler (myMsgHandler) ;

#if	! __KB_RUNTIME
	extern	void	kbWizardDummy	() ;
	kbWizardDummy	() ;
#endif

#if	__KB_KDE
	KAboutData about (APPNAME,
			  I18N_NOOP(APPTITLE),
			  RELEASE BUILD,
			  I18N_NOOP(APPTITLE ": A KDE database front end"),
			  KAboutData::License_Unknown,
			  "(c) Mike Richardson, and John Dean",
			  0,
			  "http://www.rekallrevealed.org",
			  "mike@quaking.demon.co.uk"
			 ) ;
	about.addAuthor  ("Mike Richardson", 	 0, "mike@quaking.demon.co.uk") ; 
	about.addAuthor  ("John Dean", 	     	 0, "john@totalrekall.co.uk") ; 

	KCmdLineArgs::init		(argc, argv, &about) ;
	KCmdLineArgs::addCmdLineOptions	(options) ;

	KApplication app ;

	about.setLicenseTextFile (locateFile ("appdata", "LICENSE")) ;

	if (app.isRestored ())
	{
		RESTORE (KBaseApp(QString())) ;
	}
	else 
	{
		KCmdLineArgs	*args	= KCmdLineArgs::parsedArgs () ;
		cchar		*eumdi	= getenv ("REKALL_USEMDI")    ;
		cchar		*eusdi	= getenv ("REKALL_USESDI")    ;
		QString		initDB	;

		if (args->isSet("useMDI"  ))
			__useMDI = true ;
		else if ((eumdi != 0) && (strcasecmp (eumdi, "YES") == 0))
			__useMDI = true ;

		if (args->isSet("useSDI"  ))
			__useSDI = true ;
		else if ((eusdi != 0) && (strcasecmp (eusdi, "YES") == 0))
			__useSDI = true ;

		if (args->isSet("errLocn" ))
			KBError::errDebug = 1 ;

		if (args->isSet("errTrace"))
			KBError::errDebug = 2 ;

		if (args->isSet("skipNoteDB"))
			__noNoteDB = true ;

		if (args->isSet("skipLastDB"))
			__noLastDB = true ;

		if (args->isSet("skipSplash"))
			__noSplash = true ;

		__initDEB  = args->getOption ("debug"   ) ;
		__language = args->getOption ("language") ;

		if (args->count() > 0)
			initDB	= args->url(0).path() ;


		TKConfig *config = TKConfig::getConfig() ;
		config->setApplication	  (APPNAME     ) ;

#if	! __KB_RUNTIME
		KBOptionsDlg::setupWizard (config) ;
#endif
		if (!__language.isNull())
			if (!KGlobal::locale()->setLanguage (__language))
				fprintf
				(	stderr,
					"Failed to set language [%s]\n",
					(cchar *)__language
				)	;

		if (!__noSplash)
		{
			QString	release = RELEASE BUILD ;
			new KBSplash ("rekall", release, 3000, Qt::red) ;
		}

		new KBaseApp (initDB) ;
	}

#endif
#if	__KB_TKC

#if	__KB_EMBEDDED

	QPEApplication	app (argc, argv) ;
	qpeApp	= &app	;

	for (int idx = 0 ; idx < argc ; idx += 1)
		fprintf	(stderr, "---->[%s]\n", argv[idx]) ;

#else

	QApplication	app (argc, argv) ;
	cchar		*cmd	= argv[0];
#endif

	TKConfig	*config	= TKConfig::getConfig () ;
	config->setApplication	(APPNAME     )	;

	int		ptr1	= 1	;
	int		ptr2	= 1	;
	QString		initDB	;

	while (ptr1 < argc)
	{
		if (strcmp (argv[ptr1], "--useMDI"  ) == 0)
		{	__useMDI = true	;
			ptr1	+= 1    ;
			continue	;
		}
		if (strcmp (argv[ptr1], "--useSDI"  ) == 0)
		{	__useSDI = true	;
			ptr1	+= 1    ;
			continue	;
		}
		if (strcmp (argv[ptr1], "--skipNoteDB") == 0)
		{	__noNoteDB=true	;
			ptr1	+= 1    ;
			continue	;
		}
		if (strcmp (argv[ptr1], "--skipLastDB") == 0)
		{	__noLastDB=true	;
			ptr1	+= 1    ;
			continue	;
		}
		if (strcmp (argv[ptr1], "--errLocn" ) == 0)
		{	KBError::errDebug = 1 ;
			ptr1	+= 1    ;
			continue	;
		}
		if (strcmp (argv[ptr1], "--errTrace") == 0)
		{	KBError::errDebug = 2 ;
			ptr1	+= 1    ;
			continue	;
		}
		if (strcmp (argv[ptr1], "--skipSplash") == 0)
		{	__noSplash = true ;
			ptr1	+= 1    ;
			continue	;
		}
#ifdef	_WIN32
		if (strcmp (argv[ptr1], "--showConsole") == 0)
		{	__console  = true ;
			ptr1	+= 1    ;
			continue	;
		}
#endif
#if	__KB_EMBEDDED
		if (strcmp (argv[ptr1], "-qcop") == 0)
		{
			ptr1	+= 2	;
			continue	;
		}
#endif
		argv[ptr2] = argv[ptr1] ;
		ptr1	  += 1 ;
		ptr2	  += 1 ;
	}

	argc	   = ptr2 ;
	argv[argc] = 0	  ;

	if ((argc > 1) && (argv[argc-1][0] != '-')) initDB = argv[argc-1] ;

#ifdef 	_WIN32
	QString	rootDir = QFileInfo(cmd).dirPath  () ;

	if (__console)
		if (AllocConsole())
		{
			freopen	("CON", "w", stdout) ;
			freopen	("CON", "w", stderr) ;
			fprintf	(stderr, "Starting Rekall ......\n") ;
			fprintf	(stderr, "%s (%s)\n", cmd, (cchar *)rootDir) ;
		}

	if (!rootDir.isEmpty()) setRootDir (rootDir) ;

	WSADATA wsa ;
	WSAStartup  (MAKEWORD(1,1), &wsa) ;

#endif
#ifdef	__KB_TKC
	extern	void	setAppdataDir (const QString &) ;
#ifdef 	_WIN32
	setAppdataDir	(locateDir ("appdata", "rekallui_null")) ;
#else
	setAppdataDir	(locateDir ("appdata", "rekallui.null")) ;
#endif
#endif

#if	! __KB_RUNTIME
		KBOptionsDlg::setupWizard (config) ;
#endif
	if (!__noSplash)
	{
		QString	release = RELEASE BUILD ;
		new KBSplash ("rekall", release, 3000, Qt::red) ;
	}


	new KBaseApp (initDB) ;

#if	__KB_EMBEDDED
	Config qpeConfig   ("qpe" ) ;
	qpeConfig.setGroup ("Date") ;

	switch ((DateFormat::Order)qpeConfig.readNumEntry("ShortOrder", DateFormat::DayMonthYear))
	{
		case DateFormat::DayMonthYear :
			fprintf	(stderr, "Date Order: DMY\n") ;
			KBDateTime::setDateOrder (KBDateTime::DayMonthYear) ;
			break	;

		case DateFormat::MonthDayYear :
			fprintf	(stderr, "Date Order: MYY\n") ;
			KBDateTime::setDateOrder (KBDateTime::MonthDayYear) ;
			break	;

		default	:
			fprintf	(stderr, "Date Order: def\n") ;
			KBDateTime::setDateOrder (KBDateTime::DayMonthYear) ;
			break	;
	}


	app.setStyle	   (new TKStyle) ;
	app.setName	   (APPNAME    ) ;

	QWidget	*sw = kbaseApp->showWidget() ;
	::setActiveWindow  (sw) ;

#endif

#endif

#if	__KB_EMBEDDED
	/* If the database is not runnable then set a single shot timer	*/
	/* to close it. We have to do it this way in the embedded	*/
	/* version since it seems we *have* to close from inside the	*/
	/* event loop, otherwise the icon is left for quick-start.	*/
	if (!kbaseApp->isRunable())
		QTimer::singleShot (0, kbaseApp, SLOT(close())) ;
#endif

#if	! __KB_EMBEDDED
	/* Desktop situation, nice'n'easy, just exit without ever going	*/
	/* into the event loop.						*/
	if (!kbaseApp->isRunable())
		return	1 ;
#endif

	return	app.exec() ;
}  



extern	"C"
{
	int	rekallMain
		(	int	argc,
			char	*argv[],
			AUTH	*authGbl
		)
	{
		return	rekall	(argc, argv, authGbl) ;
	}
}

