/***************************************************************************
    file	         : kb_dbaseviewer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_DBASEVIEWER_H
#define  _KB_DBASEVIEWER_H

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_part.h"


/*  KBDBaseViewer							*/
/*  -------------							*/
/*  This class is a wrapped for the general databse view window, used	*/
/*  to give direct access to tables and forms, etc.			*/

class	KBDBaseViewer : public KBasePart
{
	Q_OBJECT

	QWidget			*m_parent	;
	KBaseApp		*kbaseApp	;
	KBDBaseDlg		*dbaseDlg	;
	KBaseGUI		*dbaseGUI	;
	TKAction		*m_showDatabase	;
	QList<KBObjBase>	objects		;

private	slots	:

	void		showDatabase	()	;
	void		showRawSQL	()	;
	void		dumpDatabase	()	;
	void		loadDatabase	()	;
	void		showObjects	()	;
	void		removeObject	()	;
	void		closeDatabase	()	;

public	:

		 KBDBaseViewer	(QWidget *, KBaseApp *, const QString &, bool) ;
	virtual	~KBDBaseViewer	() ;

	virtual	KBDBaseViewer	*isDBaseViewer	() { return this  ; }

	virtual	bool		queryClose	() ;
	bool			autoStart	(KBLocation &) ;
	bool			addObject	(KBLocation &, KBObjBase *) ;
	KBDBInfo		*getDBInfo	() ;

	static	KBaseApp	*findKBaseApp	(KBLocation &) ;
}	;

#endif // _KB_DBASEVIEWER_H
