/***************************************************************************
    file	         : kbase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KBASE_H
#define  _KBASE_H
 

#ifdef		 HAVE_CONFIG_H
#include	 <config.h>
#endif

#include	<qworkspace.h>
#include	<qptrdict.h>


#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_rawsql.h"

#include	"kb_locator.h"


#define		RELEASE		"2.2.6"
#define		BUILD		""

class	KBaseApp	;
class	KBasePart	;
class	KBViewer	;
class	KBFormViewer	;
class	KBReportViewer	;
class	KBDBaseViewer	;
class	KBTableViewer	;
class	KBQueryViewer	;
class	KBTextLog	;
class	KBEditor	;
class	KBMDIWidget	;
class	KBObjBase	;
class	KBDirector	;
class	QWorkspace	;

#if	__KB_KDE
typedef	KParts::Part	__TKPart		;
#endif

#if	__KB_TKC
typedef	TKPart		__TKPart		;
#endif

/*  KBaseApp								*/
/*  --------								*/
/*  This is the root of it all. The KTMainWindow contains a single	*/
/*  QWorkspace widget in which appear the various types of window as	*/
/*  in the above classes.						*/

class	KBaseApp : public TKMainWindow
{
	Q_OBJECT

	QWorkspace		*m_mdi		;
	TKPartManager		*m_pManager	;
	KBDBaseViewer		*m_dbViewer	;
	QList<KBObjBase>	m_objects	;

	KBObjBase		*m_autoObj	;
	QWidget			*m_showWidget	;
	bool			m_available	;
	bool			m_runable	;

	virtual	bool	queryExit	() ;
	virtual	bool	queryClose	() ;

	void		fixHelpMenu	(KBDirector &) ;
	void		init		(TKConfig   *) ;
	QWidget		*openDBaseViewer(const QString &, bool, bool) ;

	KBObjBase	*loadObject	(KBLocation &) ;
	void		addGlobalAction	(TKAction   *) ;


protected :

	virtual void	resizeEvent	(QResizeEvent *) ;


public	slots	:

	void		showOptions	() ;
	void		showQueryLog	() ;
	void		showEventLog	() ;
	void		showScriptLog	() ;
	void		showDebugger	() ;
	void		openDatabase	() ;
	void		newDatabase	() ;
	void		openRecent	(const TKURL &) ;
	void		removeObject	() ;

	void		showAboutApplication	() ;

	/* The folling methods are invoked from instances of the	*/
	/* database information class, in response to users direct	*/
	/* requests to open and create objects.				*/
	bool		newObject	(KBLocation &, KBError &) ;
	KB::ShowRC	openObject	(KBLocation &, KB::ShowAs, QDict<QString> &, KBError &, const KBValue &, QDict<QString> *) ;

	void		playScore	() ;
	void		package		() ;

public	:

	void		showAboutDialog	(bool) ;

	void		guiEnable	(cchar    *, bool) ;
	void		guiEnable	(KB::GGroup, bool) ;

	void		addObject	(KBObjBase  *, KBLocation &) ;
	void		addViewer	(KBasePart  *) ;

	void		closeDatabase	(KBDBaseViewer *) ;

	KBObjBase	*showingObj	(KBLocation &) ;
	KBNode		*objectNode	(KBLocation &) ;
	KBRawSQL	*showRawSQL	(KBDBInfo   *, const QString &) ;

	bool		isRunable	()	;
	bool		isAvailable	()	;
	void		setAvailable	(bool)	;

	inline	QWidget	*showWidget	()
	{
		return	m_showWidget ;
	}


	KBaseApp (QString, bool = false, bool = true) ;
       ~KBaseApp () ;

	friend	class	KBasePart ;

	/* Static method to get the script interface for a specified	*/
	/* language, in order to pass a script to the debugger to be	*/
	/* edited. This is static since it is not meaningful to have	*/
	/* more than one debugger open per language.			*/
	static	KBScriptIF	*getDebugIface (const QString &) ;
}	;
 
 
#endif // _KBASE_H
