/***************************************************************************
    file	         : kb_objbase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_OBJBASE_H
#define	__KB_OBJBASE_H

#include	<qobject.h>
#include 	<qguardedptr.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include 	"libapp_exports.h"


/*  KBObjBase								*/
/*  ---------								*/
/*  This class is used as a base for objects, in the sense of a form,	*/
/*  report or whatever.							*/

class	LIBAPP_API KBObjBase : public QObject
{
	Q_OBJECT

	QGuardedPtr<KBasePart>	m_part		;
	bool			m_modal		;
	bool			m_inClose	;
	KBLocation		m_location	;

protected :

	int			m_rc		;

	void	setPart	(KBasePart *, bool) ;

public	:

	KBObjBase	(QObject * = 0, cchar * = 0) ;
	virtual		~KBObjBase ()	;

	virtual	bool		build
		(		KBLocation &,
				bool,
				KBError &
		) = 0 ;

	virtual	KB::ShowRC	show
		(		KB::ShowAs		,
				const QDict<QString>	&,
				QWidget			*,
				KBError			&,
				const KBValue		& = KBValue(),
				QDict<QString>		* = 0
		) = 0 ;

	virtual	QString		def	() = 0 ;

	bool	showing			(KBLocation &) ;
	bool	saveDocument		() ;
	bool	saveDocumentAs		() ;
	void	closeObject		() ;

	inline	KBasePart	*getPart ()
	{
		return	m_part	;
	}

	inline	void	setRC
		(	int	rc
		)
	{
		m_rc	= rc	;
	}

	inline	void	setLocation
		(	KBLocation &location
		)
	{
		m_location = location ;
	}

	inline	KBLocation	&getLocation ()
	{
		return	m_location ;
	}

	virtual	KBNode	*getTopNode ()
	{
		return	0 ;
	}
}	;

#endif	// __KB_OBJBASE_H
