/***************************************************************************
    file	         : kb_objtreeviewer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_OBJTREEVIEWER_H
#define	__KB_OBJTREEVIEWER_H

#if	! __KB_RUNTIME

#include	"kb_classes.h"
#include	"kb_listview.h"
#include	"kb_gui.h"
#include	"kb_viewer.h"
#include	"kb_partwidget.h"
#include	"kb_part.h"
#include	"kb_objbase.h"
#include	"kb_viewer.h"

#include 	"libapp_exports.h"

/*  KBObjTreeViewer							*/
/*  ---------------							*/
/*  Display classed used to show the tree structure of a document (in	*/
/*  terms of nodes and attributes, etc).				*/

class LIBAPP_API KBObjTreeViewer : public KBViewer
{
	Q_OBJECT

	QGuardedPtr<KBNode>	m_rootNode	;
	KBLayout		*m_layout	;
	KBListView		*m_objTree	;
	KBaseGUI		*m_gui		;

	QList<KBObject>		getObjects ()	;

private slots :

	void			showProperties	()	;
	void			selectionChanged()	;

public	:

	KBObjTreeViewer (KBObjBase *, QWidget *, KBLocation &, KBNode *, KBLayout *) ;
       ~KBObjTreeViewer () ;

public slots :

	virtual	void	showAs		(KB::ShowAs)	;
	void		doProperties	()		;
	void		doMultiProp	()		;
}	;

#endif	// ! __KB_RUNTIME
#endif	// __KB_OBJTREEVIEWER_H
