/***************************************************************************
    file	         : kb_databuffer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DATABUFFER_H
#define	__KB_DATABUFFER_H

#include	<qstring.h>

#include	"libcommon_exports.h"


/*  KBDataBuffer							*/
/*  ------------							*/
/*  This class is rather like QCString, except that it is (a) much more	*/
/*  efficient since it keeps track of the string length and pre-	*/
/*  allocates space and (b) doesn't have anything like as many methods!	*/
/*  Mainly, it is used when building up queries.			*/

class	LIBCOMMON_API	KBDataBuffer : private QByteArray
{
	uint	m_dataLength		;

public	:

	KBDataBuffer	()		;
	KBDataBuffer	(uint)		;
       ~KBDataBuffer	()		;

	void		append	(const QChar	&)	;
	void		append	(const QString  &)	;
	void		append	(const QCString &)	;

	void		append	(const char *)		;
	void		append	(const char *, uint)	;
	void		append	(char)			;

	void		clear	()		;

	uint		length	()		;
	const char	*data	()		;

	inline	QByteArray &array ()
	{
		return	*this	;
	}
}	;

#define	KBDBINCR	128

#endif	// __KB_DATABUFFER_H
