/***************************************************************************
    file	         : kb_serverinfo.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_SERVERINFO_H
#define	_KB_SERVERINFO_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include	<qdict.h>
#include	<qlabel.h>
#include	<qlistbox.h>
#include	<qlineedit.h>
#include	<qcheckbox.h>
#include	<qpushbutton.h>
#include	<qdom.h>

#include	"libcommon_exports.h"

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_tableinfo.h"



/*  KBServerInfo							*/
/*  ------------							*/
/*  KBase accesses data stored in "servers", where a server is an SQL	*/
/*  engine, such as MySQL or PostgreSQL. Note that on KBase, the term	*/
/*  "database" is used to refer to a set of server connections, forms,	*/
/*  reports, and so on, which the end user views as a database.		*/

class	LIBCOMMON_API	KBServerInfo
{
protected :

	enum	SysState
	{
		SysUnknown,
		SysPresent,
		SysMissing
	}	;

	KBDBInfo	*m_dbInfo	;	/* Parent information	*/

	QString		m_serverName	;	/* Identifying name	*/
	QString		m_dbType	;	/* Server type		*/
	QString		m_hostName	;	/* Host running server	*/
	QString		m_dbName	;	/* Server database name	*/
	QString		m_userName	;	/* Server login name	*/
	QString		m_password	;	/* Server password	*/
	QString		m_portNumber	;	/* Optional port number	*/
	QString		m_socketName	;	/* Optional socket name	*/
	QString		m_flags		;	/* Optional flags	*/
	bool		m_isDisabled	;	/* Connection disabled	*/
	bool		m_autoStart	;	/* Autostart "MainForm"	*/
	QString		m_autoForm	;	/* .... or this one	*/
	bool		m_printQueries	;	/* Debug printing	*/

	bool		m_noRekallTables;	/* No rekall tables	*/
	bool		m_showAllTables	;	/* Show all tables	*/
	bool		m_cacheTables	;	/* Cache table info	*/
	bool		m_nullUserPwd	;	/* Null user/pwd OK	*/
	bool		m_pkReadOnly	;	/* Primary key r/only	*/
	bool		m_fakeKeys	;	/* Fake insert keys	*/
	bool		m_readOnly	;	/* Read-only database	*/
	QString		m_initSQL	;	/* Initial SQL		*/
	QString		m_dataEncoding	;	/* Data encoding	*/
	QString		m_objEncoding	;	/* Object encoding	*/

#ifndef	_WIN32
	QString		m_sshTarget	;
#endif

	SysState	m_objState	;	/* Object table state	*/
	SysState	m_dictState	;	/* Design table state	*/
	bool		m_checkTabs	;	/* Checking tbl create	*/

	KBServer	*m_server	;	/* Server connection	*/
	QList<KBDBLink>	m_links		;	/* Current links	*/

	KBTableInfoSet	*m_tableInfoSet	;	/* Table information	*/
	KBDBAdvanced	*m_advanced	;	/* Advanced settings	*/


	QString		m_useUserName	;
	QString		m_usePassword	;

	void		makeObjTable		() ;
#if	0
	void		makeDesignDict		() ;
#endif
	void		checkForTables		() ;

	virtual	bool	promptUserPassword	(KBError &) ;
	virtual	bool	promptMakeObjTable	() ;
	virtual	bool	promptMakeDesignDict	() ;

public	:

	KBServerInfo (KBDBInfo *)	;
	KBServerInfo (KBDBInfo *, const KBServerInfo *) ;
	KBServerInfo (KBDBInfo *, cchar  *) ;
	KBServerInfo (KBDBInfo *, const QDomElement  &) ;

	KBServerInfo
	(	KBDBInfo *,
		cchar  *, cchar  *, cchar  *,
		cchar  *, cchar  *, cchar  *
	)	;

	virtual	~KBServerInfo () ;

	void		saveTableInfo	()		;
	void		buildSpecElement(QDomElement &) ;

	inline	const QString	&serverName	() { return m_serverName    ; }
	inline	const QString	&dbType		() { return m_dbType        ; }
	inline	const QString	&userName	() { return m_useUserName   ; }
	inline	const QString	&password	() { return m_usePassword   ; }
 	inline	const QString	&hostName	() { return m_hostName	    ; }
 	inline	const QString	&database	() { return m_dbName	    ; }
 	inline	const QString	&portNumber	() { return m_portNumber    ; }
 	inline	const QString	&socketName	() { return m_socketName    ; }
 	inline	const QString	&flags		() { return m_flags	    ; }

 	inline	bool		showAllTables	() { return m_showAllTables ; }
 	inline	bool		cacheTables	() { return m_cacheTables   ; }
 	inline	bool		printQueries	() { return m_printQueries  ; }
 	inline	bool		pkReadOnly	() { return m_pkReadOnly    ; }
 	inline	bool		fakeKeys	() { return m_fakeKeys	    ; }
 	inline	bool		readOnly	() { return m_readOnly	    ; }
	inline	const QString	&autoForm	() { return m_autoForm	    ; }
	inline	const QString	&initSQL	() { return m_initSQL	    ; }
 	inline	const QString	&dataEncoding	() { return m_dataEncoding  ; }
 	inline	const QString	&objEncoding	() { return m_objEncoding   ; }
#ifndef	_WIN32
	inline	const QString	&sshTarget	() { return m_sshTarget     ; }
#endif
	const QString		&getDBPath	() ;

	inline	void	setPort
		(	const QString	&port
		)
	{
		m_portNumber	= port	;
	}

	void			attachLink	(KBDBLink	*) ;
	void			detachLink	(KBDBLink	*) ;
	KBServer		*getServer	(KBError  	&) ;

	bool			linkIsOpen	() ;
	KBTableInfoSet		*tableInfoSet	() ;

	inline	bool		disabled     	() { return m_isDisabled		; }
	inline	bool		hasDesignDict	() { return m_dictState == SysPresent  ; }
	inline	bool		hasObjectTable	() { return m_objState  == SysPresent	; }
	inline	KBDBAdvanced	*advanced	() { return m_advanced			; }

	friend	class	KBServerDlg	;
	friend	class	KBDBInfo	;
	friend	class	KBDBAdvancedDlg	;

	static	QString		getIdentStrings	() ;
}	;

LIBCOMMON_API KBFactory		*getDriverFactory	(const QString &) ;
LIBCOMMON_API KBServer		*getDriverServer	(const QString &) ;
LIBCOMMON_API KBDBAdvanced	*getDriverAdvanced	(const QString &) ;


#endif	// _KB_SERVERINFO_H
