
%{
#undef		getc
#undef		output
#define		getc(f)		el_getc()
#define		fread(b,n,l,f)	el_read(b,n*l)
#define		read(f,b,l)	el_read(b,l)
#define		output(c)

GVAR	int	el_lineno	;
GVAR	char	*el_fname	;
LFUNC	void	comment ()	;
LFUNC	void	string	(int)	;

GFUNC	void	el_in_iinit(FILE *, const char *) ;
GFUNC	void	el_in_sinit(const char *, const char *) ;
GFUNC	int	_el_lookup (char *) ;
GFUNC	int	_el_number (char *) ;
GFUNC	int	_el_double (char *) ;
%}

alpha	[_a-zA-Z]
alnum	[_a-zA-Z0-9]
oct	[0-7]
dec	[0-9]
hex	[0-9a-fA-F]
white	[ \t]

%%


"/*"			comment () ;


\'			{
			string	('\'')		;
			return	T_CHAR		;
			}

\"			{
			string	('\"')		;
			return	T_STRING	;
			}

#line.*\n			{	char	*p ;
				free (el_fname) ;
				el_fname = p = strdup (&yytext[6]) ;
				while (*p && (*p != ' ')) p += 1 ;
				while (*p && (*p == ' ')) *p++ = 0 ;
				el_lineno = atoi (p) ;
			}

"&"			return	T_AND	;
"&&"			return	T_ANDIF	;
"="			return	T_ASSIGN;
"}"			return	T_CLOSE	;
","			return	T_COMMA	;
"~"			return	T_COMP	;
"("			return	T_LBRA	;
"-"			return	T_MINUS	;
"!="			return	T_NEQ	;
"!"			return	T_NOT	;
"{"			return	T_OPEN	;
"|"			return	T_OR	;
"||"			return	T_ORIF	;
"+"			return	T_PLUS	;
")"			return	T_RBRA	;
";"			return	T_SEMI	;
"<<"			return	T_SHL	;
">>"			return	T_SHR	;
"<"			return	T_LT	;
"<="			return	T_LTEQ	;
">"			return	T_GT	;
">="			return	T_GTEQ	;
"=="			return	T_EQ	;
"*"			return	T_MULT	;
"/"			return	T_DIV	;
"%"			return	T_REM	;
"^"			return	T_XOR	;
"["			return	T_LSUB	;
"]"			return	T_RSUB	;
"+="			return	T_APLUS	;
"-="			return	T_AMINUS;
"*="			return	T_AMULT	;
"/="			return	T_ADIV	;
"%="			return	T_AREM	;
"|="			return	T_AOR	;
"&="			return	T_AAND	;
"^="			return	T_AXOR	;
"++"			return	T_INCR	;
"--"			return	T_DECR	;
"?"			return	T_QUERY	;
":"			return	T_COLON	;
"."			return	T_DOT	;
"vec"			return	T_VEC	;
"hash"			return	T_HASH	;
"=~"			return	T_MATCH	;

{alpha}{alnum}*			 return	_el_lookup (yytext) ;
::{alpha}{alnum}*		 return	_el_lookup (yytext) ;
{alpha}{alnum}*::{alpha}{alnum}* return	_el_lookup (yytext) ;
[0-9]{dec}*\.{dec}*[Ee]{dec}*	 |
[0-9]{dec}*\.{dec}*		 return	_el_double (yytext) ;
[1-9]{dec}*			 |
-{dec}+				 |
0x{hex}+			 |
0{oct}*				 return	_el_number (yytext) ;

\n			el_lineno += 1 ;

{white}+		;
.			yyerror	("illegal character <%s/%d>", yytext, yytext[0]) ;
%%

#define	HASHSIZ	64
#define	HASHMSK	(HASHSIZ-1)

typedef	struct	keyword	KEYWORD	;

struct	keyword
{	KEYWORD		*next	;	/* Link to next in hash chain	*/
	const char	*word	;	/* Pointer at the word		*/
	int		code	;	/* Code for the word		*/
}	;

/*  keywds	: Initial table of keywords. Note that this table is	*/
/*		  inserted into the hash table on initialisation.	*/
LVAR	KEYWORD	keywds[] =
{
	{	NULL,	"break",	T_BREAK		},
	{	NULL,	"case",		T_CASE		},
	{	NULL,	"const",	T_CONST		},
	{	NULL,	"continue",	T_CONTINUE	},
	{	NULL,	"default",	T_DEFAULT	},
	{	NULL,	"else",		T_ELSE		},
	{	NULL,	"endcase",	T_ENDCASE	},
	{	NULL,	"for",		T_FOR		},
	{	NULL,	"global",	T_GLOBAL	},
	{	NULL,	"if",		T_IF		},
	{	NULL,	"local",	T_LOCAL		},
	{	NULL,	"module",	T_MODULE	},
	{	NULL,	"public",	T_PUBLIC	},
	{	NULL,	"return",	T_RETURN	},
	{	NULL,	"switch",	T_SWITCH	},
	{	NULL,	"while",	T_WHILE		},
	{	NULL,	NULL,		0		}
}	;

LVAR	KEYWORD	*hashtab[HASHSIZ] ;

/*L hashval	: Calculate hash value of string			*/
/*  str		: char *	: String in question			*/
/*  (returns)	: int		: Hash value				*/

LFUNC	int	hashval
	(	const char	*str
	)
{
	int	hval	;
	for (hval = 0 ; *str ; str += 1) hval ^= *str ;
	return	hval & HASHMSK ;
}

/*L string	: Parse a string or character				*/
/*  qch		: int		: Quote character			*/
/*  (returns)	: void		:					*/

LFUNC	void	string
	(	int	qch
	)
{
	int	ch	;
	int	ptr	;
	char	str[256];

	extern	int	yyinput (void) ;

	for (ptr = 0, ch = yyinput () ; (ch != 0) && (ch != qch) ; ch = yyinput ())
	{	if (ch == '\n')
		{	yyerror	("Newline in string/character constant") ;
			break	;
		}
		else
		{	str[ptr++] = ch ;
			if (ch == '\\') str[ptr++] = yyinput () ;
		}
	}

	str[ptr]    = 0	           ;
	yylval._str = strdup (str) ;
}

LFUNC	void	el_hashinit ()
{
	static	int	first = 1 ;

	if (first)
	{
		int	hval	;
		KEYWORD	*wptr	;

		for (wptr = keywds ; wptr->word ; wptr += 1)
		{
			hval		= hashval (wptr->word) ;
			wptr->next	= hashtab[hval] ;
			hashtab[hval]	= wptr ;
		}

		first	= 0 ;
	}
}

/*G el_lex_iinit: Initialiser routine					*/
/*  ifd		: FILE *	: Input file descriptor			*/
/*  name	: const char *	: Input file name			*/
/*  (returns)	: void		:					*/

GFUNC	void	el_lex_iinit
	(	FILE		*ifd,
		const char	*name
	)
{
	extern	void	_el_yyhack() ;
	el_hashinit () ;
	el_in_iinit (ifd, name) ;
	_el_yyhack  () ;
}

/*G el_lex_sinit: Initialiser routine					*/
/*  sstr	: const char *	: Source to compile			*/
/*  name	: const char *	: Input file name			*/
/*  (returns)	: void		:					*/

GFUNC	void	el_lex_sinit
	(	const char	*sstr,
		const char	*name
	)
{
	extern	void	_el_yyhack() ;
	el_hashinit () ;
	el_in_sinit (sstr, name) ;
	_el_yyhack  () ;
}

/*G _el_lookup	: Word lookup routine					*/
/*  word	: char *	: Word to be looked up			*/
/*  (returns)	: int		: Code for word				*/

GFUNC	int	_el_lookup
	(	char	*word
	)
{
	int	hval	= hashval (word) ;
	KEYWORD	*wptr	;

	/* Scan hash table to see of the word is already there. If so	*/
	/* then this entry will be returned.				*/
	for (wptr = hashtab[hval] ; wptr != NULL ; wptr = wptr->next)
		if (strcmp (word, wptr->word) == 0)
			break ;

	if (wptr == NULL)
	{	/* Not found so install a new enty. All new words have	*/
		/* the code T_NAME.					*/
		wptr		= (KEYWORD *)calloc(1, sizeof(KEYWORD)) ;
		wptr->next	= hashtab[hval] ;
		wptr->word	= strdup (word) ;
		wptr->code	= T_NAME	;
		hashtab[hval]	= wptr		;
	}

	
	yylval._str = wptr->word ;	/* Set token for T_NAME.	*/
	return	      wptr->code ;	/* Return the code.		*/
}

/*G _el_number	: Number conversion routine				*/
/*  numb	: char *	: String representing number		*/
/*  (returns)	: int		: T_NUMBER				*/

GFUNC	int	_el_number
	(	char	*numb
	)
{
	yylval._num = strtol (numb, NULL, 0) ;
	return	T_NUMBER ;
}

/*G _el_double	: Double conversion routine				*/
/*  numb	: char *	: String representing number		*/
/*  (returns)	: int		: T_DOUBLE				*/

GFUNC	int	_el_double
	(	char	*numb
	)
{
	yylval._dbl = strtod (numb, NULL) ;
	return	T_DOUBLE ;
}




LFUNC	void	comment ()
{
	int i ;
	extern int yyinput () ;
	while ((i = yyinput ()) != 0)
		if (i == '*')
			if ((i = yyinput ()) == '/')
				break ;
			else	unput (i) ;
	if (i == 0) yyerror ("end of  file in comment") ;
}
