/***************************************************************************
    file	         : eli.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_ELI_H

#undef	_SPACE

#include	"libel32_exports.h"

typedef	struct	methset	METHSET	;
typedef	struct	mc	MC	;
typedef	struct	eltag	ELTAG	;

class	LIBEL32_API	ELShared	;
class	LIBEL32_API	VEC		;
class	LIBEL32_API	HASH		;
class	LIBEL32_API	STRING		;
class	LIBEL32_API	IO		;
class	LIBEL32_API	ELF		;

class	LIBEL32_API	VALUE
{
public	:
	ELTAG	*tag	;
	union
	{	int		num	;
		double		dbl	;
		ELF		*elf	;
		MC		*mc	;
		VEC		*vec	;
		HASH		*hash	;
		STRING		*str	;
		VALUE		*ptr	;
		IO		*io	;
		void		*user	;
		ELShared	*shared	;
	}	val	;

		VALUE	() ;
		VALUE	(const VALUE &) ;
		VALUE	(VALUE 	     *) ;
		VALUE	(STRING	     *) ;
		VALUE	(VEC 	     *) ;
		VALUE	(IO 	     *) ;
		VALUE	(int)		;
		VALUE	(int,  ELTAG *) ;
		VALUE	(ELF *,ELTAG *) ;
		VALUE	(void*,ELTAG *) ;
	       ~VALUE	() ;

	void	operator = (int   ) ;
	void	operator = (double) ;
	void	operator = (const VALUE &) ;
	void	operator = (VALUE	*) ;
	void	operator = (STRING	*) ;
	void	operator = (VEC		*) ;
	void	operator = (HASH	*) ;
	int	operator== (const VALUE &) ;
}	;

#ifdef	_SPACE

class	LIBEL32_API	ELShared
{
public	:

	int	count	;
	int	freed	;
	ELShared*next	;

		ELShared ()
		{	EXTERN	ELShared*space	;
			count	= 1	;
			freed	= 0	;
			next	= space	;
			space	= this	;
		}

virtual	       ~ELShared ()
		{	fprintf	(stderr, "ELShared::~ELShared called") ;
			exit	(1)	;
		} ;

inline	void	ref	 ()
		{	count += 1 ;
		}

inline	void	deref	 ()
		{	if ((count -= 1) == 0) freed = 1 ;
		}
}	;

#else	/* _SPACE */
class	LIBEL32_API	ELShared
{
	int	count	;
public	:
		ELShared () { count = 1 ; }
virtual	       ~ELShared () { } ;
inline	void	ref	 () { count += 1 ; }
inline	void	deref	 () { if ((count -= 1) == 0) delete this ; }
}	;
#endif	/* _SPACE */

class	LIBEL32_API	STRING	: public ELShared
{
public	:
	char	*text	;

		STRING	(const char *) ;
		STRING	(int) ;
virtual	       ~STRING	() ;
}	;

class	LIBEL32_API	VEC	: public ELShared
{
public	:
	int	size	;
	int	alloc	;
	VALUE	*vals	;

		VEC	(int)	;
virtual	       ~VEC	()	;
	int	push	(const VALUE &) ;
	VALUE	pop	()	;
	VALUE	shift	()	;
}	;

class	LIBEL32_API	HITEM
{
public	:

	HITEM		*next	;
	VALUE		key	;
	VALUE		value	;

		HITEM	(const VALUE &) ;
}	;


#define	HTABSIZ		(32)
class	LIBEL32_API	HASH	: public ELShared
{
public	:
	VALUE	dflt	;
	HITEM	*htab	[HTABSIZ] ;

		HASH	(VALUE)	;
virtual	       ~HASH	()	;
	VALUE	*entry	(const VALUE &, int) ;
}	;

class	LIBEL32_API	IO	: public ELShared
{
public	:
	FILE	*fd	;

		IO	(FILE *) ;
virtual	       ~IO	()	 ;
}	;

class	LIBEL32_API	ELF	: public ELShared
{
public	:
	const char	*name	;
	int		*code	;

		 ELF	(const char *, int)	;
virtual		~ELF	()	;
}	;

struct	eltag
{	int		tag	;
	int		flags	;
	METHSET		*mset	;
	const char	*ident	;
}	;
#define	TF_SHARED	0x0001

struct	mc
{	const	char	*name	;
	ELTAG		*args[6];
	VALUE		(*fn)(VALUE *argv) ;
}	;

struct	methset
{	METHSET		*next	;
	ELTAG		**types	;
	MC		*mtab	;
}	;

#define	V_ANY	'x'		/* Allow any type in el_chkargs		*/
#define	V_UNDEF	'u'		/* Undefined function in master table	*/
#define	V_NUM	'n'		/* Integer number			*/
#define	V_DBL	'd'		/* Floating point number		*/
#define	V_STR	's'		/* Null terminated stringfg		*/
#define	V_ELC	'e'		/* ELC byte code routine		*/
#define	V_PUB	'c'		/* Public callable ELC routine		*/
#define	V_FN	'f'		/* C machine code routine		*/
#define	V_VEC	'v'		/* Vector of values			*/
#define	V_HASH	'h'		/* Hash of values			*/
#define	V_PTR	'p'		/* Pointer type				*/
#define	V_IO	'i'		/* Input/output				*/
#define	V_ERR	'!'		/* Error occurred			*/
#define	V_USER	'?'		/* Used in compiler			*/

extern	LIBEL32_API	ELTAG	tagANY	;
extern	LIBEL32_API	ELTAG	tagUNDEF;
extern	LIBEL32_API	ELTAG	tagNUM	;
extern	LIBEL32_API	ELTAG	tagDBL	;
extern	LIBEL32_API	ELTAG	tagSTR	;
extern	LIBEL32_API	ELTAG	tagELC	;
extern	LIBEL32_API	ELTAG	tagPUB	;
extern	LIBEL32_API	ELTAG	tagFN	;
extern	LIBEL32_API	ELTAG	tagVEC	;
extern	LIBEL32_API	ELTAG	tagHASH	;
extern	LIBEL32_API	ELTAG	tagPTR	;
extern	LIBEL32_API	ELTAG	tagIO	;
extern	LIBEL32_API	ELTAG	tagERR	;

GFUNC	int		el_error	(const char *fmt, ...) ;
GFUNC	void		el_popstk	(int num, const char *name) ;
GFUNC	int		el_init		(unsigned int csize, unsigned int ssize) ;
GFUNC	void		el_term		(void) ;
GFUNC	int		el_ffunc	(const char *name) ;
GFUNC	VALUE		el_fexec	(int idx) ;
GFUNC	const char	*el_funcn	(int idx) ;
GFUNC	VALUE		el_vexec	(const char *name, const char *func, unsigned int, VALUE *) ;
GFUNC	void		el_initlib	(MC *mptr) ;
GFUNC	int		el_findfile	(const char *file, const char *extn, char *fname) ;
GFUNC	int		el_loadfile	(const char *file) ;
GFUNC	VALUE		_el_execute	(const VALUE &func) ;
GFUNC	const char	*_el_escape	(const char *srce, char *dest, int) ;

GFUNC	void		el_initlib	(MC *) ;


#define	TOS		_el_tos
#define	PUSH(v)		{ TOS += 1 ; *TOS  = v ; }
#define	POP		{ *TOS = 0 ; TOS  -= 1 ; }


typedef	struct	_cbuff
{	int	len	;
	char	code[2]	;
}	CBUFF	;

EXTERN	CBUFF	*el_compile (const char *, const char *, FILE *, const char *, FILE *) ;
EXTERN	int	el_loadtext (CBUFF *) ;

#define	_ELI_H
#endif	/* _ELI_H */
