/***************************************************************************
    file	         : io.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<string.h>
#include	<setjmp.h>
#include	<ctype.h>
#include	<std.h>

#ifdef		_WIN32
#include	<io.h>
#else
#include	<unistd.h>
#endif

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"


/*  el_ioopen	: Open a file						*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Result				*/

VALUE	el_ioopen
	(	VALUE	*argv
	)
{
	FILE	*fd	   ;

	char	*file	= argv[0].val.str->text ;
	char	*mode	= argv[1].val.str->text ;

	if ((fd = fopen (file, mode)) == NULL)
		return VALUE (0) ;

	return	VALUE(new IO (fd)) ;
}

/*  el_ioclose	: Close a file						*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Result				*/

static	VALUE	el_ioclose
	(	VALUE	*argv
	)
{
	int r = argv[0].val.io->fd == NULL ? 0 : fclose (argv[0].val.io->fd) ;
	argv[0].val.io->fd = NULL ;
	return	VALUE (r) ;
}

/*  el_ioread	: Read from a file					*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Result				*/

static	VALUE	el_ioread
	(	VALUE	*argv
	)
{
	char	textb[256] ;
	VALUE	resval	   ;
	char	*ptr	   ;

	if (fgets (textb, sizeof(textb), argv[0].val.io->fd) == NULL)
		return	VALUE (0) ;

	if ((ptr = strchr (textb, '\n')) != NULL) *ptr = 0 ;
	return	VALUE (new STRING (textb)) ;
}

/*  el_iowrite	: Write to a file					*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Result				*/

static	VALUE	el_iowrite
	(	VALUE	*argv
	)
{
	return	VALUE (fputs (argv[1].val.str->text, argv[0].val.io->fd)) ;
}


static	MC	el_ioSpec[] =
{
	{	"read",		{		0 },	el_ioread	},
	{	"write",	{ &tagSTR,	0 },	el_iowrite	},
	{	"close",	{ 		0 },	el_ioclose	},
	{	NULL,		{		0 },	NULL		}
}	;

static	ELTAG	*el_ioAllow [] =
{
	&tagIO,
	0
}	;

METHSET	el_ioMethSet =
{
	0,
	el_ioAllow,
	el_ioSpec
}	;

/*  IO									*/
/*  IO		: Constructor for EL IO object				*/
/*  fd		: FILE *	: Associated file			*/
/*  (returns)	: IO		:					*/

IO::IO
	(	FILE	*fd
	)
	:
	fd	(fd)
{
}

/*  IO									*/
/*  ~IO		: Destructor for EL IO object				*/
/*  (returns)	: void		:					*/

IO::~IO ()
{
	if (fd != 0) fclose (fd) ;
}

/*  VALUE								*/
/*  VALUE	: VALUE constructor for IO object			*/
/*  io		: IO *		: IO object				*/
/*  (returns)	: VALUE		:					*/

VALUE::VALUE
	(	IO	*io
	)
{
	tag	= &tagIO  ;
	val.io	= io	  ;
}

