/***************************************************************************
    file	         : kb_misc.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		__KB_MISC_H
#define		__KB_MISC_H

#include	"kb_macro.h"
#include	"libextra_exports.h"


/*  KBMacroMessageBox							*/
/*  -----------------							*/
/*  Macro used to display a simple popup message box.			*/

class	LIBEXTRA_API	KBMacroMessageBox : public KBMacroInstr
{
public	:

	KBMacroMessageBox (KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	  (KBError &) ;
}	;

/*  KBMacroCancelBox							*/
/*  ----------------							*/
/*  Macro used to display a simple cancel exection query box.		*/

class	LIBEXTRA_API	KBMacroCancelBox : public KBMacroInstr
{
public	:

	KBMacroCancelBox (KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	  (KBError &) ;
}	;

/*  KBMacroPromptBox							*/
/*  ----------------							*/
/*  Macro used to display a simple prompt query box.			*/

class	LIBEXTRA_API	KBMacroPromptBox : public KBMacroInstr
{
public	:

	KBMacroPromptBox (KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	  (KBError &) ;
}	;

#endif		// __KB_MISC_H
