/***************************************************************************
    file	         : kb_misc.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_misc.h"
#include	"kb_prompt.h"

#include	"tk_messagebox.h"




/*  KBMacroMessageBox							*/
/*  KBMacroMessageBox							*/
/*		: Constructor for message box macro			*/
/*  exec	: KBMacroExec *		: Parent macro executor		*/
/*  (returns)	: KBMacroMessageBox 	:				*/

KBMacroMessageBox::KBMacroMessageBox
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "MessageBox")
{
}

/*  KBMacroMessageBox							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroMessageBox::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 1, 2, pError) ;
}

/*  KBMacroMessageBox							*/
/*  execute	: Execute macro						*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroMessageBox::execute
	(	KBError		&
	)
{
	TKMessageBox::information
	(
		0,
		m_args[0],
		m_args.count() == 1 ? QString::null : m_args[1]
	)	;

	return	true	;
}


/*  ------------------------------------------------------------------  */

/*  KBMacroCancelBox							*/
/*  KBMacroCancelBox							*/
/* 		: Macro to show OK/Cancel popup				*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroCancelBox::KBMacroCancelBox
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "CancelBox")
{
}

/*  KBMacroCancelBox							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroCancelBox::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 1, 2, pError) ;
}

/*  KBMacroCancelBox							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroCancelBox::execute
	(	KBError		&
	)
{
	if (TKMessageBox::questionYesNo
	 	(
		0,
		m_args[0],
		m_args.count() == 1 ? QString::null : m_args[1],
		TR("OK"),
		TR("Cancel")
		)
		!= TKMessageBox::Yes
	   )
	   m_exec->halt() ;

	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroPromptBox							*/
/*  KBMacroPromptBox							*/
/* 		: Macro to show prompt popup				*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroPromptBox::KBMacroPromptBox
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "PromptBox")
{
}

/*  KBMacroPromptBox							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroPromptBox::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 1, 3, pError) ;
}

/*  KBMacroPromptBox							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroPromptBox::execute
	(	KBError		&
	)
{
	QString		value	= m_args.count() >= 3 ? m_args[2] : QString::null ;
	QString		caption	= m_args.count() >= 2 ? m_args[1] : QString::null ;

	KBPromptDlg	prDlg	(caption, m_args[0], value) ;

	if (!prDlg.exec())
	{
		m_exec->halt()	;
		return	true	;
	}

	m_exec->addValue ("value", value) ;
	return	true	;
}

NEWMACRO(MessageBox)
NEWMACRO(CancelBox)
NEWMACRO(PromptBox)

#ifdef	__DOCS
  <macro name="DebugEnable">
    <arg type="choice" legend="Enable">
      <choice value="On"/>
      <choice value="Off"/>
    </arg>
      <![CDATA[
        <h3>Debug Enable</h3>
        If macro debugging is set to <i>On Demand</i> in the options
        dialog, then this macro will enable or disable debugging of
        subsequent macro instructions.
      ]]>
  </macro>
  <macro name="MessageBox">
    <arg type="text" legend="Message"></arg>
    <arg type="text" legend="Caption"></arg>
      <![CDATA[
        <h3>Message Box</h3>
        A simple message box is displayed with the specified message and,
        optionally, caption. Execution is paused until the user clicks the
        OK button.
      ]]>
  </macro>
  <macro name="CancelBox">
    <arg type="text" legend="Message"></arg>
    <arg type="text" legend="Caption"></arg>
      <![CDATA[
        <h3>Message Box</h3>
        A simple prompt box is displayed with the specified message and,
        optionally, caption. Execution is paused until the user clicks the
        OK or Cancel button; if cancel is clicked the macro execution
        is terminated.
      ]]>
  </macro>
  <macro name="PromptBox">
    <arg type="text" legend="Message"></arg>
    <arg type="text" legend="Caption"></arg>
    <arg type="text" legend="Default"></arg>
      <![CDATA[
        <h3>Prompt Box</h3>
        A simple prompt box is displayed with the specified message and,
        optionally, caption. The user can enter a value which is saved
        by the macro. If the user clicks Cancel then macro execution
        is terminated.
      ]]>
  </macro>
#endif	// __DOCS
