/***************************************************************************
    file	         : kb_attraligndlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>

#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_attralign.h"
#include	"kb_node.h"


#ifndef 	_WIN32
#include 	"kb_attraligndlg.moc"
#else
#include 	"kb_attraligndlg.h"
#endif





/*  KBAttrAlignDlg							*/
/*  KBAttrAlignDlg							*/
/*		: Constructor for alignment dialog			*/
/*  parent	: QWidget *		: Parent widget			*/
/*  attr	: KBAttr *		: Associated attribute		*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: All attributes		*/
/*  (returns)	: KBAttrAlignDlg	:				*/

KBAttrAlignDlg::KBAttrAlignDlg
	(	QWidget			*parent,
		KBAttr			*attr,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
	:
	KBAttrDlg	(parent, attr, item, attrDict),
	m_upDown    	(this),
	m_leftRight 	(this),
	m_richText  	(this)
{
	QLabel	    *lUpDown	= new QLabel (this) ;
	QLabel	    *lLeftRight	= new QLabel (this) ;

	QGridLayout *layMain	= new QGridLayout (this) ;

	layMain   ->addWidget (lLeftRight,   0, 0) ;
	layMain   ->addWidget (lUpDown,      1, 0) ;
	layMain   ->addWidget (&m_leftRight, 0, 1) ;
	layMain   ->addWidget (&m_upDown,    1, 1) ;


	lUpDown   ->setText   (TR("Vertical"      )) ;
	lLeftRight->setText   (TR("Horizontal"    )) ;

	/* HACK : If the node is a label then allow the rich-text	*/
	/*	  option. Otherwise, this is not shown.			*/
	KBNode *node = m_item->attr()->getOwner() ;
	if (node->inherits("KBLabel"))
	{
		QLabel	    *lRichText	= new QLabel (this) ;
		QWidget	    *spacer	= new QWidget(this) ;

		layMain	  ->addWidget (spacer,       2, 0) ;
		layMain   ->addWidget (lRichText,    3, 0) ;
		layMain   ->addWidget (&m_richText,  3, 1) ;
		lRichText ->setText   (TR("Show rich text")) ;

		spacer ->setFixedHeight(8)	;
		layMain->setRowStretch (4, 1)	;
	}
	else
	{
		m_richText.hide        ()	;
		layMain->setRowStretch (2, 1)	;
	}

	m_upDown   .insertItem(TR("Top"   )) ;
	m_upDown   .insertItem(TR("Center")) ;
	m_upDown   .insertItem(TR("Bottom")) ;

	m_leftRight.insertItem(TR("Left"  )) ;
	m_leftRight.insertItem(TR("Center")) ;
	m_leftRight.insertItem(TR("Right" )) ;

	connect
	(	&m_richText,
		SIGNAL(toggled	     (bool)),
		SLOT  (toggleRichText(bool))
	)	;
}

/*  KBAttrAlignDlg							*/
/*  init	: Initialise for editing				*/
/*  value	: const QString & : Value				*/
/*  (returns)	: bool		  : False, no modal dialog		*/

bool	KBAttrAlignDlg::init
	(	const QString	&value
	)
{
	uint	v = value.toInt() ;

	if (v != RICHTEXT)
	{
		switch (v & Horizontal_Mask)
		{
			case 0		  :
			case AlignLeft	  :
				m_leftRight.setCurrentItem (0) ;
				break	;

			case AlignHCenter :
				m_leftRight.setCurrentItem (1) ;
				break	  ;

			case AlignRight :
				m_leftRight.setCurrentItem (2) ;
				break	  ;

			default :
				break	  ;
		}

		switch (v & Vertical_Mask)
		{
			case 0		  :
			case AlignTop	  :
				m_upDown   .setCurrentItem (0) ;
				break	;

			case AlignVCenter :
				m_upDown   .setCurrentItem (1) ;
				break	  ;

			case AlignBottom  :
				m_upDown   .setCurrentItem (2) ;
				break	  ;

			default :
				break	  ;
		}

		m_leftRight.setEnabled (true ) ;
		m_upDown   .setEnabled (true ) ;
		m_richText .setChecked (false) ;
	}
	else
	{
		m_leftRight.setEnabled (false) ;
		m_upDown   .setEnabled (false) ;
		m_richText .setChecked (true ) ;
	}

	return	false	;
}

/*  KBAttrAlignDlg							*/
/*  value	: Get value						*/
/*  (returns)	: QString	:					*/

QString	KBAttrAlignDlg::value ()
{
	uint	v	= 0 ;

	if (!m_richText.isChecked ())
	{
		switch (m_leftRight.currentItem())
		{
			case 0 : v |= Qt::AlignLeft    ; break ;
			case 1 : v |= Qt::AlignHCenter ; break ;
			case 2 : v |= Qt::AlignRight   ; break ;
			default: break ;
		}
		switch (m_upDown   .currentItem())
		{
			case 0 : v |= Qt::AlignTop     ; break ;
			case 1 : v |= Qt::AlignVCenter ; break ;
			case 2 : v |= Qt::AlignBottom  ; break ;
			default: break ;
		}
	}
	else	v	= 0x1001 ;

	return	QString("%1").arg(v) ;
}

void	KBAttrAlignDlg::toggleRichText
	(	bool	on
	)
{
	m_leftRight.setEnabled (!on) ;
	m_upDown   .setEnabled (!on) ;
}
