/***************************************************************************
    file	         : kb_attrdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qheader.h>
#include	<qcache.h>
#include	<qregexp.h>
#include	<qfile.h>
#include	<qtextstream.h>

#ifndef 	_WIN32
#include	"kb_attrdlg.moc"
#else 
#include 	"kb_attrdlg.h"
#endif

#include	"kb_attr.h"


/*  KBAttrDlg								*/
/*  KBAttrDlg	: Constructor for attribute dialog base			*/
/*  parent	: QWidget *		: Parent widget			*/
/*  attr	: KBAttr *		: Associated attribute		*/
/*  item	: KBAttrItem *		: Item being edited		*/
/*  attrDict	: QDict<KBAttrItem> &	: Distcionary of all attributes	*/
/*  (returns)	: KBAttrDlg		:				*/

KBAttrDlg::KBAttrDlg
	(	QWidget			*parent,
		KBAttr			*attr,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
	:
	QWidget		(parent),
	m_attr		(attr),
	m_item		(item),
	m_attrDict	(attrDict)
{
}

/*  KBAttrDlg								*/
/*  ~KBAttrDlg	: Destructor for attribute dialog base			*/
/*  (returns)	:		:					*/

KBAttrDlg::~KBAttrDlg ()
{
}

/*  KBAttrDlg								*/
/*  getAttrVal	: Get value of named attribute				*/
/*  name	: const QString &	: Name of attribute		*/
/*  (returns)	: QString		: Value				*/

QString	KBAttrDlg::getAttrVal
	(	const QString	&name
	)
{
	/* Note that this returns the current value in the context of	*/
	/* the property editor, which will be different from the node's	*/
	/* attribute if the user has edited it.				*/
	KBAttrItem *item   = m_attrDict.find (name) ;
	return	item == 0 ? QString::null : item->value() ;
}

void	KBAttrDlg::verify ()
{
}

bool	KBAttrDlg::init ()
{
	return	init (m_item == 0 ? QString::null : m_item->value()) ;
}

void	KBAttrDlg::save ()
{
	if (m_item != 0) m_item->setValue (value()) ;
}

QString	KBAttrDlg::displayValue ()
{
	return	m_attr->displayValue (value()) ;
}

/*  ------------------------------------------------------------------  */

KBAttrDlgDialog::KBAttrDlgDialog
	(	KBAttrDlg	*attrDlg,
		const QString	&caption
	)
	:
	_KBDialog	("", true),
	m_attrDlg	(attrDlg),
	m_bOK		(this, "ok"    ),
	m_bCancel	(this, "cancel")
{
	setCaption	(caption) ;

	attrDlg->reparent (this, QPoint(0,0)) ;

	QVBoxLayout	*layMain = new QVBoxLayout (this) ;
	layMain->addWidget (m_attrDlg) ;

	QHBoxLayout	*layButt = new  QHBoxLayout (layMain) ;
	layButt->addStretch() ;
	layButt->addWidget (&m_bOK) ;
	layButt->addWidget (&m_bCancel) ;

	_KBDialog::setupLayout (attrDlg, -1, -1) ;
}

KBAttrDlgDialog::~KBAttrDlgDialog ()
{
	m_attrDlg->reparent (0, QPoint(0,0)) ;
}

void	KBAttrDlgDialog::accept ()
{
	m_attrDlg->save () ;
	done	(1) ;
}

void	KBAttrDlgDialog::reject ()
{
	done	(0) ;
}

int	KBAttrDlgDialog::exec ()
{
	return	_KBDialog::exec() ;
}

