/***************************************************************************
    file	         : kb_attrmargin.cpp
    copyright            : (C)	1999,2000,2001,2002,2003,2004,2005
				 by Mike Richardson
			   (C)	2001,2002,2003,2004,2005
				by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	"kb_attrmargin.h"
#include	"kb_attrmargindlg.h"

static	int	getAttrValue
	(	const QDict<QString>	&aDict,
		cchar			*name,
		int			defval
	)
{
	QString	*v = aDict.find (name)  ;
	return	v == 0 ? defval : v->toInt() ;
}


/*  KBAttrMargin							*/
/*  KBAttrMargin: Constructor for Margin attribute			*/
/*  owner	: KBObject *		: Owning object			*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/
/*  (returns)	: KBAttrMargin		:				*/

KBAttrMargin::KBAttrMargin
	(	KBObject		*owner,
		const QDict<QString>	&aDict,
		uint			flags
	)
	:
	KBAttr	(owner, KBAttr::Base, "_margin", aDict, flags|KAF_GRPFORMAT)
{
	m_lMargin	= getAttrValue	(aDict, "lmargin", 0) ;
	m_rMargin	= getAttrValue	(aDict, "rmargin", 0) ;
	m_tMargin	= getAttrValue	(aDict, "tmargin", 0) ;
	m_bMargin	= getAttrValue	(aDict, "bmargin", 0) ;
}

/*  KBAttrMargin							*/
/*  KBAttrMargin: Constructor for Margin attribute			*/
/*  owner	: KBObject *		: Owning object			*/
/*  extant	: KBObject *		: Extant object			*/
/*  (returns)	: KBAttrMargin		:				*/

KBAttrMargin::KBAttrMargin
	(	KBObject		*owner,
		KBObject		*extant
	)
	:
	KBAttr
	(	owner,
		"_margin",
		extant,
		extant->getAttr("_margin")->getFlags()
	)
{
	KBAttrMargin *o = (KBAttrMargin *)extant->getAttr("_margin") ;

	m_lMargin	= o->m_lMargin ;
	m_rMargin	= o->m_rMargin ;
	m_tMargin	= o->m_tMargin ;
	m_bMargin	= o->m_bMargin ;
}

/*  KBAttrMargin							*/
/*  printAttr	: Print attribute					*/
/*  attrText	: QString &	: Result text for attribute output	*/
/*  nodeText	: QString &	: Result text for node output		*/
/*  indent	: int		: Indent depth for node output		*/
/*  flat	: bool		: Generate flatened version		*/
/*  (returns)	: void		:					*/

void	KBAttrMargin::printAttr
	(	QString		&attrText,
		QString		&,
		int		
	)
{
	addAttrText (attrText, "lmargin", QString::number(m_lMargin)) ;
	addAttrText (attrText, "rmargin", QString::number(m_rMargin)) ;
	addAttrText (attrText, "tmargin", QString::number(m_tMargin)) ;
	addAttrText (attrText, "bmargin", QString::number(m_bMargin)) ;
}

/*  KBAttrMargin							*/
/*  getValue	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBAttrMargin::getValue () const
{
	/* Should not actually be called, so its really just a bit of a	*/
	/* filler.							*/
	return	QString	("%1,%2,%3,%4")
			.arg(m_lMargin)
			.arg(m_rMargin)
			.arg(m_tMargin)
			.arg(m_bMargin)
			;
}

#if	! __KB_RUNTIME

/*  KBAttrMargin							*/
/*  getAttrItem	: Get item for property dialogs				*/
/*  (returns)	: KBAttrItem *	:					*/

KBAttrItem
	*KBAttrMargin::getAttrItem ()
{
	return	new KBAttrMarginItem (this) ;
}

#endif
