/***************************************************************************
    file	         : kb_attrvpage.h
    copyright            : (C)	1999,2000,2001,2002,2003,2004,2005
				 by Mike Richardson
			   (C)	2001,2002,2003,2004,2005
				by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef	__KB_ATTRVPAGE_H
#define	__KB_ATTRVPAGE_H

#include	"kb_attr.h"
#include	"kb_object.h"

class	KBAttrItem	;

/*  KBAttrVPage								*/
/*  ------------							*/
/*  Class used for report virtual page settings, wraps the values into	*/
/*  one attribute.							*/

class	LIBKBASE_API	KBAttrVPage : public KBAttr
{
public	:

	bool		m_enabled	;
	int		m_colWidth	;
	int		m_rowHeight	;
	int		m_colGap	;
	int		m_rowGap	;
	bool		m_borders	;
	bool		m_skip		;

	KBAttrVPage
	(	KBObject		*,
		const QDict<QString>	&,
		uint			= 0
	)	;
	KBAttrVPage
	(	KBObject		*,
		KBObject		*
	)	;

	virtual	QString		getValue	() const	;
	virtual	void		printAttr 	(QString &, QString &, int) ;

#if	! __KB_RUNTIME
	virtual	KBAttrItem	*getAttrItem	() ;
#endif

}	;

#endif	// __KB_ATTRVPAGE_H
