/***************************************************************************
    file	         : kb_compaccessdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COMPONENTDLG_H
#define	__KB_COMPONENTDLG_H

#include	<qdict.h>

#include	<qtextview.h>
#include	<qcombobox.h>
#include	<qlistbox.h>
#include	<qlistview.h>
#include	<qpushbutton.h>
#include	<qwidgetstack.h>
#include	<qtabwidget.h>

#if		__KB_EMBEDDED
#include	<qmultilineedit.h>
#else
#include	<qtextedit.h>
#endif

#include	<qdir.h>
#include	<qfileinfo.h>

#include	"libkbase_exports.h"

#include	"kb_docchooser.h"
#include	"kb_prompt.h"
#include	"kb_wizard.h"
#include	"kb_attrdlg.h"

#include	"tk_lineedit.h"


/*  KBWizardAttrDlg							*/
/*  ---------------							*/
/*  Special wizard control used to provide a button which allows the	*/
/*  user to edit a value via an KBAttrDlg dialog.			*/

class	LIBKBASE_API KBWizardAttrDlg : public KBWizardCtrl
{
	Q_OBJECT

	TKLineEdit	*m_lineEdit	;
	KBAttrDlgDialog	*m_attrDlg	;
	QString		m_value		;

protected slots :

	void		slotClickDlg	() ;

public	:

	KBWizardAttrDlg
	(	KBWizardPage	*,
		const QString	&,
		const QString	&,
		const QString	&,
		KBAttrDlg	*
	)	;
	virtual	~KBWizardAttrDlg	()	;

	virtual	void	setValue	(const QString &) ;
	virtual	QString	value		()	;
}	;

/*  ------------------------------------------------------------------  */

/*  KBWizardModalCtrl							*/
/*  -----------------							*/
/*  This is used as a base class for adding controls that edit values	*/
/*  via standard modal dialogs.						*/

class	LIBKBASE_API KBWizardModalCtrl : public KBWizardCtrl
{
	Q_OBJECT

protected slots :

	virtual	void		slotClickDlg	() = 0 ;

protected :

	TKLineEdit	*m_lineEdit	;
	QString		m_value		;

public	:

	KBWizardModalCtrl
	(	KBWizardPage	*,
		const QString	&,
		const QString	&,
		const QString	&
	)	;
	virtual	~KBWizardModalCtrl	()	;

	virtual	void	setValue	(const QString &) ;
	virtual	QString	value		()	;
}	;

/*  KBWizardColorCtrl							*/
/*  -----------------							*/
/*  Special wizard control used to provide a button which allows the	*/
/*  user to edit a value via the standard color dialog.			*/

class	LIBKBASE_API KBWizardColorCtrl : public KBWizardModalCtrl
{
protected :

	virtual void		slotClickDlg	() ;

public	:

	KBWizardColorCtrl
	(	KBWizardPage	*,
		const QString	&,
		const QString	&,
		const QString	&
	)	;
	virtual	~KBWizardColorCtrl	()	;
}	;

/*  KBWizardFontCtrl							*/
/*  ----------------							*/
/*  Similarly for font selection .....					*/

class	LIBKBASE_API KBWizardFontCtrl : public KBWizardModalCtrl
{
protected :

	virtual	void		slotClickDlg	() ;

public	:

	KBWizardFontCtrl
	(	KBWizardPage	*,
		const QString	&,
		const QString	&,
		const QString	&
	)	;
	virtual	~KBWizardFontCtrl	()	;
}	;

/*  ------------------------------------------------------------------  */

/*  KBComponentWizardPage						*/
/*  ---------------------						*/
/*  This class is a simple derivation from KBWizardPage, and simply	*/
/*  exists so that we can add some component specific controls to the	*/
/*  page.								*/

class	KBComponentWizardPage : public KBWizardPage
{
public	:

	inline	KBComponentWizardPage
		(	QWidget 	*parent
		)
		:
		KBWizardPage
		(	0,
			parent,
			QString::null
		)
	{
	}

	KBWizardAttrDlg	  *addAttrDlg	(const QString &, const QString &, const QString &, KBAttrDlg  *) ;
	KBWizardColorCtrl *addColorCtrl	(const QString &, const QString &, const QString &) ;
	KBWizardFontCtrl  *addFontCtrl	(const QString &, const QString &, const QString &) ;
}	;


/*  ------------------------------------------------------------------  */

/*  KBComponentLoadDlg							*/
/*  ------------------							*/
/*  This dialog is used to select and customise components both from	*/
/*  the stock components and user (database) components.		*/

class	LIBKBASE_API	KBComponentLoadDlg : public _KBDialog
{
	Q_OBJECT

	KBDBInfo		*m_dbInfo		;
	QString			m_svName		;
	QString			m_language		;

	QTabWidget		m_tab			;

	QWidget			m_pick			;

	QComboBox		m_cbServer		;
	QWidgetStack		m_docStack		;
	QListBox		m_lbDocument		;
	QListView		m_lvStock		;
	QListView		m_lvLocal		;
	QPushButton		m_bOK			;
	QPushButton		m_bCancel		;

	QTextView		m_comment		;
	QWidgetStack		m_wizard		;
	QWidget			m_blank			;

	QWidgetStack		m_example		;


	QSize			m_size			;

	QString			m_stockDir		;
	QString			m_stockPath		;
	QString			m_document		;

	bool			m_paste			;
	KB::ObjType		m_reqdType		;
	KB::ObjType		m_showType		;
	bool			m_selected		;
	KBLocation		m_location		;

	KBComponent		*m_component		;
	KBComponent		*m_rendered		;
	QWidget			*m_topWidget		;

	QString			m_pageKey		;
	QDict<KBComponentWizardPage>
				m_pages			;
	KBComponentWizardPage	*m_currPage		;

	void		showDetails		()	;
	void		getStockComponents	(const QString &, QListView &, QListViewItem *) ;
	bool		text			(QByteArray    &,  KBError &) ;

	bool		addSpecialConfig	(KBConfig      *) ;
	void		substitute		(KBComponent   *) ;
	void		render			(KBComponent   *) ;

	virtual	bool	eventFilter		(QObject *, QEvent *) ;

protected slots :

	void		serverSelected	(const QString &) ;

	void		documentSelected(const QString &) ;
	void		stockSelected	(QListViewItem *) ;
	void		localSelected	(QListViewItem *) ;

	void		tabPageChanged	(QWidget       *) ;

	virtual	void	clickOK		()	;
	virtual	void	clickCancel	()	;

public	:

	KBComponentLoadDlg
	(	KBDBInfo 		*,
		const QString		&,
		const QString		&,
		QSize			,
		bool			,
		KB::ObjType
	)	;
	~KBComponentLoadDlg () ;

	KBComponent	*component	(KBError &)	;

	inline	QString	server		()
	{
		return	m_cbServer  .currentText()	;
	}
	inline	QString	document	()
	{
		return	m_document ;
	}

	void	getAllConfigs		(KBObject *, QList<KBConfig> &, bool, bool) ;
}	;


/*  KBComponentSaveDlg							*/
/*  ------------------							*/
/*  Dialog used when saving an object in a form or report as a		*/
/*  component, based on the standard save dialog.			*/

class	LIBKBASE_API	KBComponentSaveDlg : public KBPromptSaveDlg
{
	Q_OBJECT

	QLabel		m_textLabel	;
#if	__KB_EMBEDDED
	QMultiLineEdit	m_textEdit	;
#else
	QTextEdit	m_textEdit	;
#endif
	QString		&m_comment	;
	bool		*m_toFile	;

protected slots :

	virtual	void	accept () 	;

public	:

	KBComponentSaveDlg
	(	QString		&,
		QString		&,
		QString		&,
		KBDBInfo	*,
		bool		*
	)	;
}	;

/*  saveComponentToFile							*/
/*  -------------------							*/
/*  Helper function to save a component definition to a file, typically	*/
/*  the local component repository.					*/

extern	void	saveComponentToFile (const QString &, const QString &) ;

#endif	// __KB_COMPONENTDLG_H
