/***************************************************************************
    file	         : kb_conductor.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_CONDUCTOR_H
#define	__KB_CONDUCTOR_H

#include	"libkbase_exports.h"

#include	<qwidget.h>
#include	<qdialog.h>
#include	<qpushbutton.h>
#include	<qtextbrowser.h>
#include	<qlayout.h>

#include	<qguardedptr.h>
#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_dom.h"

#if		__KB_KDE
#include	<kprocess.h>
#endif

class	KBConductor	;
class	KBPlayer	;
class	KProcess	;


struct	LIBKBASE_API MsgBuff
{
	uint	len	;
	uint	seq	;
	uint	code	;
	char	buff[1]	;
}	;

/*  KBConductor								*/
/*  -----------								*/
/*  Control class for the score player system.				*/

class LIBKBASE_API KBConductor : public QObject
{
	Q_OBJECT

	enum	State
	{	
		StateIdle,
		StateLeadin,
		StateStanza,
		StatePause,
		StatePreSnap,
		StatePostSnap
	}	;

#if	__KB_KDE
	QList<KBPlayer>	m_players	;
	QDomDocument	m_score		;
	QDomElement	m_stanza	;

	State		m_state		;
	bool		m_withDlg	;
	QList<MsgBuff>	m_sending	;

	KProcess	m_process	;
#endif

	void	writeToDialog	(MsgBuff *	) ;
	void	sendToDialog	(uint, uint, const QString & = "") ;
	bool	sendMessage	(uint)	;
	void	sendReady	(uint)	;
	void	sendSnapshot	(uint)	;
	bool	snapshot	(KBPlayer *, const QString &, KBError &) ;

	bool	doPerform	(KBError  &) ;
	bool	doSnapshot	(KBError  &, const QString &) ;

	void	startDelay	(int, State) ;

private	slots	:

	void	wroteStdin	(KProcess *) ;
	void	receivedStdout	(KProcess *, char *, int) ;
	void	processExited	(KProcess *) ;


public	slots	:

	void	nextStanza	()	;

public	:

	KBConductor		() ;
       ~KBConductor		() ;

	void	addPlayer	(KBPlayer *) ;
	void	remPlayer	(KBPlayer *) ;

	bool	init		(const QString &, KBError &, bool) ;
	void	start		() ;

	static	KBConductor	*self	() ;
}	;


/*  KBPlayer								*/
/*  --------								*/
/*  This class is instantiated as part of any object which should be	*/
/*  driven using a score.						*/

class	LIBKBASE_API	KBPlayer
{
	QString		m_class		;
	QString		m_type		;
	QWidget		*m_widget	;
	KBNode		*m_node		;

public	:

	KBPlayer
	(	const QString &,
		const QString &,
		QWidget   * = 0,
		KBNode    * = 0
	)	;

	virtual	~KBPlayer	()	;

	inline	void	setWidget
		(	QWidget	*widget
		)
	{
		m_widget = widget ;
	}

	inline	const QString	&playerClass	() { return m_class	; }
	inline	const QString	&playerType	() { return m_type	; }
	inline	QWidget		*playerWidget	() { return m_widget	; }
	inline	KBNode		*playerNode	() { return m_node	; }

	virtual	QString		playerName	() ;

	virtual	bool		playerPerform
				(	const QString	  &,
					const QStringList &,
					KBError		  &
				)	;
}	;

#endif	// __KB_CONDUCTOR_H
