/***************************************************************************
    file	         : kb_copyexec.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COPYEXEC_H
#define	__KB_COPYEXEC_H

#include 	"libkbase_exports.h"


#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_copybase.h"
#include	"kb_param.h"
#include	"kb_paramsetdlg.h"

#include	"tk_progress.h"



/*  KBCopyExec								*/
/*  ----------								*/
/*  Class used to handle copier operation, ie., to execute a copy	*/
/*  between a source and a destination					*/

class	LIBKBASE_API	KBCopyExec
{
	KBCopyBase	*m_srce		;
	KBCopyBase	*m_dest		;
	QDict<QString>	*m_paramDict	;
	TKProgress	*m_progress	;

public	:

	KBCopyExec	(KBCopyBase *, KBCopyBase *) ;
	virtual	~KBCopyExec	()		;

	virtual	bool	showProgress	(int)	;

	bool		execute
			(	QString		 	&,
				KBError			&,
				int			&,
				const QDict<QString>	&,
				QDict<KBParamSet>	&,
				bool			= true
			)	;

	/* The static "execDocument" method loads and executes a	*/
	/* specified copier document ...				*/
	static	int	execDocument
			(	KBLocation 		&,
				QString			&,
				KBError			&,
				const QDict<QString>	&,
				bool			= true
			) ;
}	;

#endif	// __KB_COPYEXEC_H
