/***************************************************************************
    file	         : kb_docchooser.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>

#ifndef 	_WIN32
#include	"kb_docchooser.moc"
#else
#include	"kb_docchooser.h"
#endif

#include	"kb_dbdociter.h"
#include	"kb_serverinfo.h"


/*  KBDocChooser							*/
/*  KBDocChooser: Constructor for document chooser			*/
/*  dbInfo	: KBDBInfo *	  : Database information		*/
/*  cbServer	: QComboBox &	  : Server selector			*/
/*  cbDocument	: QComboBox &	  : Document selector			*/
/*  docType	: const QString & : Document type			*/
/*  docExtn	: const QString & : Document extension			*/
/*  stock	: bool		  : Include stock compents		*/
/*  (returns)	: KBDocChooser	  :					*/

KBDocChooser::KBDocChooser
	(	KBDBInfo	*dbInfo,
		QComboBox	&cbServer,
		QComboBox	&cbDocument,
		const QString	&docType,
		const QString	&docExtn,
		bool		stock
	)
	:
	m_dbInfo	(dbInfo),
	m_cbServer	(cbServer),
	m_cbDocument 	(cbDocument),
	m_docType	(docType),
	m_docExtn	(docExtn)
{
	QListIterator<KBServerInfo> *svIter = dbInfo->getServerIter () ;
	KBServerInfo		    *svInfo ;

	if (stock)
		m_cbServer.insertItem (KBLocation::m_pStock) ;

	m_cbServer.insertItem (KBLocation::m_pFile) ;

	while ((svInfo = svIter->current()) != 0)
	{
		m_cbServer.insertItem (svInfo->serverName()) ;
		(*svIter) += 1 ;
	}

	delete	svIter	;

	connect	(&m_cbServer,   SIGNAL(activated       (const QString &)),
		 	        SLOT  (serverSelected  (const QString &))) ;
	connect	(&m_cbDocument, SIGNAL(activated       (const QString &)),
		 	        SLOT  (documentSelected(const QString &))) ;

	serverSelected (m_cbServer.currentText()) ;
}

/*  KBDocChooser								*/
/*  serverSelected							*/
/*		: User selects a database server			*/
/*  svName	: const QString & : Server name				*/
/*  (returns)	: void		  :					*/

void	KBDocChooser::serverSelected
	(	const QString	&svName
	)
{
	m_cbDocument.clear () ;
	emit serverChanged () ;

	QString	    name    ;
	QString	    stamp   ;
	KBError	    error   ;

	KBDBDocIter docIter ;
	if (!docIter.init (m_dbInfo, svName, m_docType, m_docExtn, error))
	{	error.DISPLAY() ;
		return	;
	}

	while (docIter.getNextDoc (name, stamp))
		m_cbDocument.insertItem (name) ;

	emit	documentChanged () ;
}

/*  KBDocChooser								*/
/*  documentSelected							*/
/*		: User selects an document				*/
/*  objName	: const QString & : Document name			*/
/*  (returns)	: void		  :					*/

void	KBDocChooser::documentSelected
	(	const QString	&
	)
{
	emit	documentChanged	() ;
}

/*  KBDocChooser								*/
/*  setServer	: Set specifier server					*/
/*  svrName	: const QString & : Server name				*/
/*  (returns)	: bool		  : Server name valid			*/

bool	KBDocChooser::setServer
	(	const QString	&svrName
	)
{
	bool	rc	= false ;

	m_cbServer.setCurrentItem (0) ;

	for (int idx = 0 ; idx < m_cbServer.count() ; idx += 1)
		if (m_cbServer.text(idx) == svrName)
		{	m_cbServer.setCurrentItem (idx) ;
			serverSelected		  (svrName) ;
			rc	= true	;
			break	;
		}

	emit	serverChanged () ;
	return	rc ;
}

/*  KBDocChooser							*/
/*  setDocument	: Set specifier document				*/
/*  docName	: const QString & : Document name			*/
/*  (returns)	: bool		  : Document name valid			*/

bool	KBDocChooser::setDocument
	(	const QString	&docName
	)
{
	bool	rc	= false ;

	m_cbDocument.setCurrentItem (0) ;

	for (int idx = 0 ; idx < m_cbDocument.count() ; idx += 1)
		if (m_cbDocument.text(idx) == docName)
		{	m_cbDocument.setCurrentItem (idx) ;
			documentSelected	    (docName) ;
			rc	= true	;
			break	;
		}

	emit	documentChanged () ;
	return	rc ;
}


/*  ------------------------------------------------------------------  */

/*  KBDocChooserDlg							*/
/*  KBDocChooserDlg							*/
/*		: Simple server/document selection dialog			*/
/*  dbInfo	: KBDBInfo *	  : Database information		*/
/*  docType	: const QString & : Document type			*/
/*  docExtn	: const QString & : Document extension			*/
/*  stock	: bool		  : Include stock compents		*/
/*  (returns)	: KBDocChooserDlg :					*/

KBDocChooserDlg::KBDocChooserDlg
	(	KBDBInfo	*dbInfo,
		const QString	&docType,
		const QString	&docExtn,
		bool		stock
	)
	:
	_KBDialog	("Pick document", true),
	m_dbInfo	(dbInfo),
	m_cbServer	(this),
	m_cbDocument	(this),
	m_lServer 	(this),
	m_lDocument	(this),
	m_chooser	(m_dbInfo, m_cbServer, m_cbDocument, docType, docExtn, stock),
	m_bOK		(this),
	m_bCancel	(this)
{
	m_layMain	  = new QGridLayout(this) ;
	m_layMain->addWidget (&m_lServer,    0, 0) ;
	m_layMain->addWidget (&m_cbServer,   0, 1) ;
	m_layMain->addWidget (&m_lDocument,  1, 0) ;
	m_layMain->addWidget (&m_cbDocument, 1, 1) ;
	m_layMain->addWidget (&m_bCancel,    3, 0) ;
	m_layMain->addWidget (&m_bOK,        3, 1) ;

	m_layMain->setMargin (8) ;
	m_layMain->setSpacing(4) ;
	m_layMain->setRowStretch (2, 1) ;

	m_lServer  .setText (TR("Server"  )) ;
	m_lDocument.setText (TR("Document")) ;
	m_bCancel  .setText (TR("Cancel"  )) ;
	m_bOK      .setText (TR("OK"      )) ;

	connect	 (&m_bOK,     SIGNAL(clicked	    ()), SLOT(clickOK    ())) ;
	connect	 (&m_bCancel, SIGNAL(clicked	    ()), SLOT(clickCancel())) ;
	connect  (&m_chooser, SIGNAL(documentChanged()), SLOT(changed    ())) ;

	changed	 () ;
}

/*  KBDocChooserDlg							*/
/*  changed	: Selection changed					*/
/*  (returns)	: void		:					*/

void	KBDocChooserDlg::changed ()
{
	m_bOK.setEnabled
	(	!m_cbServer  .currentText().isEmpty() &&
		!m_cbDocument.currentText().isEmpty()
	)	;
}

/*  KBDocChooserDlg							*/
/*  clickOK	: User clicks OK					*/
/*  (returns)	: void		:					*/

void	KBDocChooserDlg::clickOK ()
{
	done	(true)  ;
}

/*  KBDocChooserDlg							*/
/*  clickCancel	: User clicks cancel					*/
/*  (returns)	: void		:					*/

void	KBDocChooserDlg::clickCancel ()
{
	done	(false) ;
}
