/***************************************************************************
    file	         : kb_errordlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_ERRORDLG_H
#define	_KB_ERRORDLG_H

#include "libkbase_exports.h"

#include	<qdialog.h>
#include	<qpushbutton.h>
#include	<qlabel.h>
#include	<qtextview.h>
#include	<qlayout.h>

#include	"kb_classes.h"


/*  KBErrorDlg								*/
/*  ----------								*/
/*  Dialog class used to display errors. Has an extension, but does it	*/
/*  in house so that we don't get stuck with a fixed geometry when	*/
/*  extended.								*/

class 	LIBKBASE_API	KBErrorDlg : public QDialog
{
	Q_OBJECT

	QPushButton	m_bOK	 	;
	QPushButton	m_bDetails 	;

	QLabel		m_lIcon	 	;
	QLabel		m_lMessage 	;

	QVBoxLayout	m_layMain	;

	KBError::EType	m_etype		;
	QString		m_detailText	;
	QString		m_srceMsg	;
	QString		m_destMsg	;

	QTextView	*m_tDetails	;
	QLabel		*m_srceLabel 	;
	QLabel		*m_srceFile	;
	QLabel		*m_destLabel 	;
	QLabel		*m_destFile	;
	QGridLayout	*m_layDetails	;

	bool		m_expanded 	;
	QSize		m_baseSize	;

protected slots :

	void	slotDetails ()	 ;

public	:

	KBErrorDlg
	(	KBError::EType	,
		const QString	&,
		const QString	&,
		const QString	&,
		cchar 		*,
		uint		,
		cchar		*,
		uint
	)	;

	~KBErrorDlg	()	;

	int	exec	()	;
}	;

#endif	// _KB_ERRORDLG_H
