/***************************************************************************
    file	         : kb_formdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"kb_formdlg.moc"
#else
#include	"kb_formdlg.h"
#endif

#include	"kb_form.h"
#include	"kb_param.h"

#include	"tk_messagebox.h"



/*  KBFormPropDlg							*/
/*  KBFormPropDlg: Constructor for root properties dialog		*/
/*  root	 : KBForm *	   : Root node				*/
/*  caption	 : cchar *	   : Caption text			*/
/*  attribs	 : QList<KBAttr  >&:Attributes list			*/
/*  scripts	 : QList<KBModule>&: List of script modules		*/
/*  imports	 : QList<KBModule>&: List of import modules		*/
/*  params	 : QList<KBParam >&: List of parameters modules		*/
/*  iniAttr	 : cchar *	   : Initial attribute			*/
/*  (returns)	 : KBFormPropDlg   :					*/

KBFormPropDlg::KBFormPropDlg
	(	KBForm		*root,
		cchar		*caption,
		QList<KBAttr  >	&attribs,
		QList<KBModule>	&scripts,
		QList<KBModule>	&imports,
		QList<KBParam > &params, 
		cchar		*iniAttr
	)
	:
	KBPropDlg (root, caption, attribs, iniAttr),
	scriptDlg (&topWidget, root, scripts),
	importDlg (&topWidget, root, imports),
	paramDlg  (&topWidget, root, params ),
	root	  (root)
{
	scriptDlg.hide() ;
	importDlg.hide() ;
	paramDlg .hide() ;
}

/*  KBFormPropDlg							*/
/*  ~KBFormPropDlg: Constructor for root properties dialog		*/
/*  (returns)	  :		:					*/

KBFormPropDlg::~KBFormPropDlg ()
{
}

/*  KBFormPropDlg							*/
/*  hideProperty : Check whether to hide attribute property		*/
/*  attr	 : KBAttr *	: Attribute in question			*/
/*  (returns)	 : bool		: True to hide				*/

bool	KBFormPropDlg::hideProperty
	(	KBAttr	*attr
	)
{
	/* Since KBForm is derived from KBBlock, there are a whole lot	*/
	/* of properties which we must ignore; so check just for those	*/
	/* of our own.							*/
	if (qstrcmp (attr->getOwnerName(), "KBForm") == 0)
		return	false	;

//	if ( (name == "language" ) ||
//	     (name == "caption"  ) ||
//	     (name == "modlist"  ) ||
//	     (name == "implist"  ) ||
//	     (name == "paramlist") ||
//	     (name == "onload"	 ) ||
//	     (name == "onunload" ) ||
//	     (name == "onclose"  ) ||
//	     (name == "stretch"  ) ||
//	     (name == "modal"    ) ||
//	     (name == "hidebars" ) ||
//	     (name == "blktype"  ) ) return false ;

	return	true	;
}


/*  KBFormPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBFormPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	QString	aName	= item->attr()->getName () ;

	/* The script module list is handled entirely locally, with	*/
	/* none of the default KBPropDlg controls.			*/
	if (aName == "modlist")
	{
		setUserWidget (&scriptDlg) ;
		return	true	 ;
	}
	if (aName == "implist")
	{
		setUserWidget (&importDlg) ;
		return	true	 ;
	}
	if (aName == "paramlist")
	{
		setUserWidget (&paramDlg ) ;
		return	true	 ;
	}

	/* Block type options are shown using the KBPropDlg combobox,	*/
	/* initialised with the set of possibilities. Also, the first	*/
	/* time round, make a note of the current form setting.		*/
	if (aName == "blktype")
	{
		comboBox.clear	     () ;
		comboBox.insertItem  (TR("Menu-only block" )) ;
		comboBox.insertItem  (TR("Table block"     )) ;
		comboBox.insertItem  (TR("SQL block"       )) ;
		comboBox.insertItem  (TR("Query block"     )) ;

		QString	value = item->value() ;

		if	(value == "null" ) comboBox.setCurrentItem (0) ;
		else if (value == "sql"  ) comboBox.setCurrentItem (2) ;
		else if (value == "query") comboBox.setCurrentItem (3) ;
		else			   comboBox.setCurrentItem (1) ;

		comboBox.show () ;

		if (ibtype.isNull()) ibtype = value ;
		return	true	 ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBFormPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBFormPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	QString	aName	= item->attr()->getName() ;

	/* As for showing the script module list, saving the results is	*/
	/* handled locally.						*/
	if (aName == "modlist"  )
	{
		setProperty  ("modlist",   scriptDlg.getText()) ;
		return	true ;
	}
	if (aName == "implist"  )
	{
		setProperty  ("implist",   importDlg.getText()) ;
		return	true ;
	}
	if (aName == "paramlist")
	{
		setProperty  ("paramlist", paramDlg .getText()) ;
		return	true ;
	}

	/* Similarly handle the block type here ...			*/
	if (aName == "blktype")
	{
		static	cchar	*vals[] =
		{	"null",
			"table",
			"sql",
			"query"
		}	;

		/* Get the selected type. If this is a change from the	*/
		/* current block type then warn the user that a change	*/
		/* will trash the form contents.			*/
		cchar	*newTyp	= vals[comboBox.currentItem()] ;

		if (!ibtype.isEmpty() && (newTyp != ibtype))
			if (TKMessageBox::questionYesNo
			   	(	0,
					TR("Changing block type will reset form contents; continue?"),
					TR("Change block type")
				)
				!= TKMessageBox::Yes) return false ;

		setProperty (item, newTyp) ;
		return	true ;
	}

	return	KBPropDlg::saveProperty (item) ;
}

/*  KBFormPropDlg:							*/
/*  clickOK	 : Handle OK button click				*/
/*  (returns)	 : void		:					*/

void	KBFormPropDlg::clickOK ()
{
	scriptDlg.fixUp () ;
	importDlg.fixUp () ;
	paramDlg .fixUp () ;

	KBPropDlg::clickOK () ;
}

/*  KBFormPropDlg:							*/
/*  preExec	  : Called immediately before QDialog::exec		*/
/*  (returns)	  : void	:					*/

void	KBFormPropDlg::preExec ()
{
	/* Trap this and load the notional hidden attribute. We have to	*/
	/* do this here since it is not until "KBPropDlg::exec" has	*/
	/* been called that "setProperty" will work.			*/
	setProperty  ("modlist",   scriptDlg.getText()) ;
	setProperty  ("implist",   importDlg.getText()) ;
	setProperty  ("paramlist", paramDlg .getText()) ;
}


/*  formPropDlg	: Run the root properties dialog box			*/
/*  form	: KBForm *	  : Form node				*/
/*  caption	: cchar *	  : Caption text			*/
/*  attribs	: QList<KBAttr >& :Attributes list			*/
/*  scripts	: QList<KBModule>&: List of script modules		*/
/*  imports	: QList<KBModule>&: List of import modules		*/
/*  params	: QList<KBParam >&: List of parameters modules		*/
/*  iniAttr	: cchar *	  : Initial attribute			*/
/*  (returns)	: bool		  : Success				*/

bool LIBKBASE_API formPropDlg
	(	KBForm		*form,
		cchar		*caption,
		QList<KBAttr  >	&attribs,
		QList<KBModule>	&scripts,
		QList<KBModule>	&imports,
		QList<KBParam > &params, 
		cchar		*iniAttr
	)
{
	KBFormPropDlg fDlg (form, caption, attribs, scripts, imports, params, iniAttr) ;
	return	fDlg.exec  () ;
}
