/***************************************************************************
    file	         : kb_label.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		_WIN32
#include	"kb_label.moc"
#else
#include	"kb_label.h"
#endif

#include	"kb_nodereg.h"


/*  KBLabel								*/
/*  KBLabel	: Consructor for label node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBLabel	:					*/

KBLabel::KBLabel
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBObject(parent, "KBLabel", 	aList),
	text	(this,   "text",	aList),
	fgcolor	(this,   "fgcolor",     aList),
	bgcolor	(this,   "bgcolor",     aList),
	frame	(this,	 "frame",	aList),
	font	(this,	 "font",	aList),
	align	(this,	 "align",	aList),
	m_buddy	(this,	 "buddy",	aList, KF_FORM)
{
	label	= 0 ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!labelPropDlg (this, "Label", attribs))
		{	delete this	;
			*ok	= false ;
			return	    ;
		}

		*ok	= true	;
	}
#endif
	if (getParent() != 0) report = getParent()->getReport () ;
}

/*  KBLabel								*/
/*  KBLabel	: Consructor for label node				*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _label	: KBLabel *	: Extant label				*/
/*  (returns)	: KBLabel	:					*/

KBLabel::KBLabel
	(	KBNode		*_parent,
		KBLabel		*_label
	)
	:
	KBObject(_parent,		_label),
	text	(this,   "text",	_label),
	fgcolor	(this,   "fgcolor",     _label),
	bgcolor	(this,   "bgcolor",     _label),
	frame	(this,	 "frame",	_label),
	font	(this,	 "font",	_label),
	align	(this,	 "align",	_label),
	m_buddy	(this,	 "buddy",	_label, KF_FORM)
{
	label	= 0 ;

	if (getParent() != 0) report = getParent()->getReport () ;
}

/*  KBLabel								*/
/*  ~KBLabel	: Desructor for label node				*/
/*  (returns)	:		:					*/

KBLabel::~KBLabel ()
{
//	fprintf	(stderr, "Delete label: %s\n", (const char *)text.getValue()) ;
}

/*  KBLabel								*/
/*  buildCtrls	: Build controls for this node				*/
/*  numrows	: uint		: Number of rows to be displayed	*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBLabel::buildCtrls
	(	uint		numrows,
		int		dx,
		int		dy
	)
{
	KBObject::buildCtrls (numrows, dx, dy) ;

	if (label == 0)
	{
		label	= new KBCtrlLabel (getDisplay(), this) ;
		setControl (label)  ;
	}

	setText	   	   (text.getValue()) ;
	label->KBControl::setGeometry (geometry     ()) ;
	label->KBControl::setVisible  (true) ;
	setPalette 	   () ;
	setFont 	   () ;
}

/*  KBLabel								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBLabel::showAs
	(	KB::ShowAs	mode
	)
{
	KBObject::showAs (mode) ;
	setText	(text.getValue()) ;
}


/*  KBLabel								*/
/*  setPalette	: Set palette						*/
/*  (returns)	: void		:					*/

void	KBLabel::setPalette ()
{
	DELOBJ	(curPal) ;
	if (label != 0) label->KBControl::setPalette (getPalette (true)) ;
}

/*  KBLabel								*/
/*  replicate	: Replicate this label					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New label node			*/

KBNode	*KBLabel::replicate
	(	KBNode	*_parent
	)
{
	return	new KBLabel (_parent, this) ;
}


/*  KBLabel								*/
/*  updateProps	: Update properties					*/
/*  (returns)	: void		:					*/

void	KBLabel::updateProps ()
{
	KBObject::updateProps ()  ;
	setText	(text.getValue()) ;

	if (getAlign() == 0x1001)
	{
		label->setAlignment  (Qt::AlignLeft) ;
		label->setTextFormat (Qt::RichText ) ;
	}
	else
	{	label->setTextFormat (Qt::PlainText) ;
		label->setAlignment  (getAlign   ()) ;
	}

	redraw	()	;
}

#if	! __KB_RUNTIME

/*  KBLabel								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBLabel::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!labelPropDlg (this, "Label", attribs, iniAttr)) return false ;
	updateProps () ;

	return	true	;
}
#endif

NEWNODE(Label, __TR("New &Label"), KF_FORM|KF_REPORT|KF_BLOCK|KF_STATIC)
